package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:TCP_EQUIP_HISTORY *
 * @author genrator
 */
public class TcpEquipHistory_mapper extends TcpEquipHistory implements BaseMapper<TcpEquipHistory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<TcpEquipHistory> ROW_MAPPER = new TcpEquipHistoryRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String CreateTime = "create_time";
    public static final String EquipId = "equip_id";
    public static final String StartTime = "start_time";
    public static final String EndTime = "end_time";
    public static final String DataRec = "data_rec";
    public static final String DataRecTotal = "data_rec_total";
    public static final String DataSend = "data_send";
    public static final String DataSendTotal = "data_send_total";
    public static final String Year = "year";
    public static final String Dept = "dept";
    public static final String EquipNum = "equip_num";

    /**
     * 默认构造函数
     */
    public TcpEquipHistory_mapper(TcpEquipHistory tcpEquipHistory) {
        if (tcpEquipHistory == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (tcpEquipHistory.isset_id) {
            this.setId(tcpEquipHistory.getId());
        }
        //普通属性
        if (tcpEquipHistory.isset_createTime) {
            this.setCreateTime(tcpEquipHistory.getCreateTime());
        }
        if (tcpEquipHistory.isset_equipId) {
            this.setEquipId(tcpEquipHistory.getEquipId());
        }
        if (tcpEquipHistory.isset_startTime) {
            this.setStartTime(tcpEquipHistory.getStartTime());
        }
        if (tcpEquipHistory.isset_endTime) {
            this.setEndTime(tcpEquipHistory.getEndTime());
        }
        if (tcpEquipHistory.isset_dataRec) {
            this.setDataRec(tcpEquipHistory.getDataRec());
        }
        if (tcpEquipHistory.isset_dataRecTotal) {
            this.setDataRecTotal(tcpEquipHistory.getDataRecTotal());
        }
        if (tcpEquipHistory.isset_dataSend) {
            this.setDataSend(tcpEquipHistory.getDataSend());
        }
        if (tcpEquipHistory.isset_dataSendTotal) {
            this.setDataSendTotal(tcpEquipHistory.getDataSendTotal());
        }
        if (tcpEquipHistory.isset_year) {
            this.setYear(tcpEquipHistory.getYear());
        }
        if (tcpEquipHistory.isset_dept) {
            this.setDept(tcpEquipHistory.getDept());
        }
        if (tcpEquipHistory.isset_equipNum) {
            this.setEquipNum(tcpEquipHistory.getEquipNum());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(tcp_equip_history.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "tcp_equip_history";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(EquipId, this.getEquipId(), this.isset_equipId);
        ib.set(StartTime, this.getStartTime(), this.isset_startTime);
        ib.set(EndTime, this.getEndTime(), this.isset_endTime);
        ib.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ib.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ib.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ib.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ib.set(Year, this.getYear(), this.isset_year);
        ib.set(Dept, this.getDept(), this.isset_dept);
        ib.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Year, this.getYear(), this.isset_year);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Year, this.getYear(), this.isset_year);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Year, this.getYear(), this.isset_year);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, equip_id, start_time, end_time, data_rec, data_rec_total, data_send, data_send_total, year, dept, equip_num from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, equip_id, start_time, end_time, data_rec, data_rec_total, data_send, data_send_total, year, dept, equip_num from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public TcpEquipHistory mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public TcpEquipHistory toTcpEquipHistory() {
        return super.$clone();
    }
}

/**
 * tcp_equip_history RowMapper
 *
 * @author genrator
 */
class TcpEquipHistoryRowMapper implements RowMapper<TcpEquipHistory> {

    @Override
    public TcpEquipHistory mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        TcpEquipHistory tcp_equip_history = new TcpEquipHistory();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.Id);
        if (columnIndex > 0) {
            tcp_equip_history.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setCreateTime(null);
            } else {
                tcp_equip_history.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.EquipId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setEquipId(null);
            } else {
                tcp_equip_history.setEquipId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.StartTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setStartTime(null);
            } else {
                tcp_equip_history.setStartTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.EndTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setEndTime(null);
            } else {
                tcp_equip_history.setEndTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.DataRec);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setDataRec(null);
            } else {
                tcp_equip_history.setDataRec(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.DataRecTotal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setDataRecTotal(null);
            } else {
                tcp_equip_history.setDataRecTotal(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.DataSend);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setDataSend(null);
            } else {
                tcp_equip_history.setDataSend(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.DataSendTotal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setDataSendTotal(null);
            } else {
                tcp_equip_history.setDataSendTotal(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.Year);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setYear(null);
            } else {
                tcp_equip_history.setYear(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.Dept);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_history.setDept(null);
            } else {
                tcp_equip_history.setDept(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipHistory_mapper.EquipNum);
        if (columnIndex > 0) {
            tcp_equip_history.setEquipNum(rs.getString(columnIndex));
        }
        return tcp_equip_history;
    }
}
