package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:TCP_EQUIP_STATUS *
 * @author genrator
 */
public class TcpEquipStatus_mapper extends TcpEquipStatus implements BaseMapper<TcpEquipStatus> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<TcpEquipStatus> ROW_MAPPER = new TcpEquipStatusRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String CreateTime = "create_time";
    public static final String EquipId = "equip_id";
    public static final String LiveStatus = "live_status";
    public static final String StartTime = "start_time";
    public static final String EndTime = "end_time";
    public static final String DataRec = "data_rec";
    public static final String DataRecTotal = "data_rec_total";
    public static final String DataSend = "data_send";
    public static final String DataSendTotal = "data_send_total";
    public static final String Dept = "dept";
    public static final String EquipNum = "equip_num";

    /**
     * 默认构造函数
     */
    public TcpEquipStatus_mapper(TcpEquipStatus tcpEquipStatus) {
        if (tcpEquipStatus == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (tcpEquipStatus.isset_id) {
            this.setId(tcpEquipStatus.getId());
        }
        //普通属性
        if (tcpEquipStatus.isset_createTime) {
            this.setCreateTime(tcpEquipStatus.getCreateTime());
        }
        if (tcpEquipStatus.isset_equipId) {
            this.setEquipId(tcpEquipStatus.getEquipId());
        }
        if (tcpEquipStatus.isset_liveStatus) {
            this.setLiveStatus(tcpEquipStatus.getLiveStatus());
        }
        if (tcpEquipStatus.isset_startTime) {
            this.setStartTime(tcpEquipStatus.getStartTime());
        }
        if (tcpEquipStatus.isset_endTime) {
            this.setEndTime(tcpEquipStatus.getEndTime());
        }
        if (tcpEquipStatus.isset_dataRec) {
            this.setDataRec(tcpEquipStatus.getDataRec());
        }
        if (tcpEquipStatus.isset_dataRecTotal) {
            this.setDataRecTotal(tcpEquipStatus.getDataRecTotal());
        }
        if (tcpEquipStatus.isset_dataSend) {
            this.setDataSend(tcpEquipStatus.getDataSend());
        }
        if (tcpEquipStatus.isset_dataSendTotal) {
            this.setDataSendTotal(tcpEquipStatus.getDataSendTotal());
        }
        if (tcpEquipStatus.isset_dept) {
            this.setDept(tcpEquipStatus.getDept());
        }
        if (tcpEquipStatus.isset_equipNum) {
            this.setEquipNum(tcpEquipStatus.getEquipNum());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(tcp_equip_status.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "tcp_equip_status";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(EquipId, this.getEquipId(), this.isset_equipId);
        ib.set(LiveStatus, this.getLiveStatus(), this.isset_liveStatus);
        ib.set(StartTime, this.getStartTime(), this.isset_startTime);
        ib.set(EndTime, this.getEndTime(), this.isset_endTime);
        ib.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ib.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ib.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ib.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ib.set(Dept, this.getDept(), this.isset_dept);
        ib.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(LiveStatus, this.getLiveStatus(), this.isset_liveStatus);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(LiveStatus, this.getLiveStatus(), this.isset_liveStatus);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(EquipId, this.getEquipId(), this.isset_equipId);
        ub.set(LiveStatus, this.getLiveStatus(), this.isset_liveStatus);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(DataRec, this.getDataRec(), this.isset_dataRec);
        ub.set(DataRecTotal, this.getDataRecTotal(), this.isset_dataRecTotal);
        ub.set(DataSend, this.getDataSend(), this.isset_dataSend);
        ub.set(DataSendTotal, this.getDataSendTotal(), this.isset_dataSendTotal);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(EquipNum, this.getEquipNum(), this.isset_equipNum);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, equip_id, live_status, start_time, end_time, data_rec, data_rec_total, data_send, data_send_total, dept, equip_num from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, equip_id, live_status, start_time, end_time, data_rec, data_rec_total, data_send, data_send_total, dept, equip_num from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public TcpEquipStatus mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public TcpEquipStatus toTcpEquipStatus() {
        return super.$clone();
    }
}

/**
 * tcp_equip_status RowMapper
 *
 * @author genrator
 */
class TcpEquipStatusRowMapper implements RowMapper<TcpEquipStatus> {

    @Override
    public TcpEquipStatus mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        TcpEquipStatus tcp_equip_status = new TcpEquipStatus();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.Id);
        if (columnIndex > 0) {
            tcp_equip_status.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setCreateTime(null);
            } else {
                tcp_equip_status.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.EquipId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setEquipId(null);
            } else {
                tcp_equip_status.setEquipId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.LiveStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setLiveStatus(null);
            } else {
                tcp_equip_status.setLiveStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.StartTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setStartTime(null);
            } else {
                tcp_equip_status.setStartTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.EndTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setEndTime(null);
            } else {
                tcp_equip_status.setEndTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.DataRec);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setDataRec(null);
            } else {
                tcp_equip_status.setDataRec(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.DataRecTotal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setDataRecTotal(null);
            } else {
                tcp_equip_status.setDataRecTotal(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.DataSend);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setDataSend(null);
            } else {
                tcp_equip_status.setDataSend(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.DataSendTotal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setDataSendTotal(null);
            } else {
                tcp_equip_status.setDataSendTotal(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.Dept);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip_status.setDept(null);
            } else {
                tcp_equip_status.setDept(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquipStatus_mapper.EquipNum);
        if (columnIndex > 0) {
            tcp_equip_status.setEquipNum(rs.getString(columnIndex));
        }
        return tcp_equip_status;
    }
}
