package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:TCP_EQUIP *
 * @author genrator
 */
public class TcpEquip_mapper extends TcpEquip implements BaseMapper<TcpEquip> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<TcpEquip> ROW_MAPPER = new TcpEquipRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String CreateTime = "create_time";
    public static final String Dept = "dept";
    public static final String Num = "num";
    public static final String Name = "name";
    public static final String TypeCode = "type_code";
    public static final String Summary = "summary";
    public static final String Vendor = "vendor";
    public static final String Status = "status";
    public static final String UserId = "user_id";
    public static final String ProtocolResolver = "protocol_resolver";
    public static final String BindUser = "bind_user";

    /**
     * 默认构造函数
     */
    public TcpEquip_mapper(TcpEquip tcpEquip) {
        if (tcpEquip == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (tcpEquip.isset_id) {
            this.setId(tcpEquip.getId());
        }
        //普通属性
        if (tcpEquip.isset_createTime) {
            this.setCreateTime(tcpEquip.getCreateTime());
        }
        if (tcpEquip.isset_dept) {
            this.setDept(tcpEquip.getDept());
        }
        if (tcpEquip.isset_num) {
            this.setNum(tcpEquip.getNum());
        }
        if (tcpEquip.isset_name) {
            this.setName(tcpEquip.getName());
        }
        if (tcpEquip.isset_typeCode) {
            this.setTypeCode(tcpEquip.getTypeCode());
        }
        if (tcpEquip.isset_summary) {
            this.setSummary(tcpEquip.getSummary());
        }
        if (tcpEquip.isset_vendor) {
            this.setVendor(tcpEquip.getVendor());
        }
        if (tcpEquip.isset_status) {
            this.setStatus(tcpEquip.getStatus());
        }
        if (tcpEquip.isset_userId) {
            this.setUserId(tcpEquip.getUserId());
        }
        if (tcpEquip.isset_protocolResolver) {
            this.setProtocolResolver(tcpEquip.getProtocolResolver());
        }
        if (tcpEquip.isset_bindUser) {
            this.setBindUser(tcpEquip.getBindUser());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(tcp_equip.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "tcp_equip";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(Dept, this.getDept(), this.isset_dept);
        ib.set(Num, this.getNum(), this.isset_num);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(TypeCode, this.getTypeCode(), this.isset_typeCode);
        ib.set(Summary, this.getSummary(), this.isset_summary);
        ib.set(Vendor, this.getVendor(), this.isset_vendor);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(UserId, this.getUserId(), this.isset_userId);
        ib.set(ProtocolResolver, this.getProtocolResolver(), this.isset_protocolResolver);
        ib.set(BindUser, this.getBindUser(), this.isset_bindUser);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(TypeCode, this.getTypeCode(), this.isset_typeCode);
        ub.set(Summary, this.getSummary(), this.isset_summary);
        ub.set(Vendor, this.getVendor(), this.isset_vendor);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(UserId, this.getUserId(), this.isset_userId);
        ub.set(ProtocolResolver, this.getProtocolResolver(), this.isset_protocolResolver);
        ub.set(BindUser, this.getBindUser(), this.isset_bindUser);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(TypeCode, this.getTypeCode(), this.isset_typeCode);
        ub.set(Summary, this.getSummary(), this.isset_summary);
        ub.set(Vendor, this.getVendor(), this.isset_vendor);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(UserId, this.getUserId(), this.isset_userId);
        ub.set(ProtocolResolver, this.getProtocolResolver(), this.isset_protocolResolver);
        ub.set(BindUser, this.getBindUser(), this.isset_bindUser);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Dept, this.getDept(), this.isset_dept);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(TypeCode, this.getTypeCode(), this.isset_typeCode);
        ub.set(Summary, this.getSummary(), this.isset_summary);
        ub.set(Vendor, this.getVendor(), this.isset_vendor);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(UserId, this.getUserId(), this.isset_userId);
        ub.set(ProtocolResolver, this.getProtocolResolver(), this.isset_protocolResolver);
        ub.set(BindUser, this.getBindUser(), this.isset_bindUser);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, dept, num, name, type_code, summary, vendor, status, user_id, protocol_resolver, bind_user from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, dept, num, name, type_code, summary, vendor, status, user_id, protocol_resolver, bind_user from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public TcpEquip mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public TcpEquip toTcpEquip() {
        return super.$clone();
    }
}

/**
 * tcp_equip RowMapper
 *
 * @author genrator
 */
class TcpEquipRowMapper implements RowMapper<TcpEquip> {

    @Override
    public TcpEquip mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        TcpEquip tcp_equip = new TcpEquip();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Id);
        if (columnIndex > 0) {
            tcp_equip.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setCreateTime(null);
            } else {
                tcp_equip.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Dept);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setDept(null);
            } else {
                tcp_equip.setDept(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Num);
        if (columnIndex > 0) {
            tcp_equip.setNum(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Name);
        if (columnIndex > 0) {
            tcp_equip.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.TypeCode);
        if (columnIndex > 0) {
            tcp_equip.setTypeCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Summary);
        if (columnIndex > 0) {
            tcp_equip.setSummary(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Vendor);
        if (columnIndex > 0) {
            tcp_equip.setVendor(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setStatus(null);
            } else {
                tcp_equip.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.UserId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setUserId(null);
            } else {
                tcp_equip.setUserId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.ProtocolResolver);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setProtocolResolver(null);
            } else {
                tcp_equip.setProtocolResolver(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, TcpEquip_mapper.BindUser);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                tcp_equip.setBindUser(null);
            } else {
                tcp_equip.setBindUser(rs.getLong(columnIndex));
            }
        }
        return tcp_equip;
    }
}
