package com.iplatform.model.to;

import com.walker.web.OrgType;
import com.walker.web.UserType;

import java.io.Serializable;

/**
 * 用户机构远程调用定义传输对象，serviceApi接口使用。
 * @author 时克英
 * @date 2023-06-06
 */
public class UserAndDeptTo implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[deptName=").append(this.deptName)
                .append(", parentId=").append(this.parentId)
                .append(", orgId=").append(this.orgId)
                .append(", menuType=").append(this.menuType)
                .append(", userName=").append(this.userName)
                .append(", nickName=").append(this.nickName)
                .append(", userType=").append(this.userType)
                .append(", type=").append(this.type)
                .append("]").toString();
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public long getParentId() {
        return parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getOrgId() {
        return orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public int getOrgType() {
        return orgType;
    }

    public void setOrgType(int orgType) {
        this.orgType = orgType;
    }

    public int getMenuType() {
        return menuType;
    }

    public void setMenuType(int menuType) {
        this.menuType = menuType;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public int getUserType() {
        return userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private String password;
    private String createId;
    private String deptName;
    private long parentId;
    private long orgId = 0;
    private int orgType = OrgType.TYPE_ORG;
    private int menuType = 0;

    private String userName;    // 登录名
    private String nickName;    // 昵称（姓名）
    private int userType = UserType.TYPE_ADMIN;
    private String sex = "0";
    private String avatar;
    private int type = UserType.TYPE_MERCHANT_ADMIN;

    private String phone;
    private String mail;
}
