package com.iplatform.model.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.ArrayList;
import java.util.List;

/**
 * 配置分类对象定义。
 * @author 时克英
 * @date 2023-05-15
 */
public class CategoryTreeVo {

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getPid() {
        return pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<CategoryTreeVo> getChild() {
        return child;
    }

    public void setChild(List<CategoryTreeVo> child) {
        this.child = child;
    }

    /**
     * 新添加字段，关联的表单名称，extra字段里是formId。
     * @return
     * @date 2023-05-18
     */
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    private String formName;
    private Integer id;

//    @ApiModelProperty(value = "父级ID")
    private Integer pid;

//    @ApiModelProperty(value = "路径")
    private String path;

//    @ApiModelProperty(value = "分类名称")
    private String name;

//    @ApiModelProperty(value = "类型，类型，1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类， 6 配置分类， 7 秒杀配置")
    private Integer type;

//    @ApiModelProperty(value = "地址")
    private String url;

//    @ApiModelProperty(value = "扩展字段")
    private String extra;

//    @ApiModelProperty(value = "状态, 0正常，1失效")
    private Boolean status;

//    @ApiModelProperty(value = "排序")
    private Integer sort;

    @JsonInclude(JsonInclude.Include.NON_EMPTY) //属性为 空（""）[] 或者为 NULL 都不序列化
    private List<CategoryTreeVo> child = new ArrayList<>(8);
}
