package com.iplatform.report.support;

import com.iplatform.base.VariableConstants;
import com.iplatform.base.util.TokenUtils;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 开源积木报表鉴权配置，实现报表接口。
 * @date 2023-03-09
 */
public class JimuReportTokenService implements JmReportTokenServiceI {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getUsername(String token) {
//        String loginId = this.getLoginId(token);
//        if(StringUtils.isEmpty(loginId)){
//            return StringUtils.EMPTY_STRING;
//        }
//        logger.debug("loginId = {}", loginId);
//        return loginId;
        return "admin";
    }

    @Override
    public Boolean verifyToken(String token) {
        logger.debug("report verifyToken(token), token={}", token);
        String loginId = this.getLoginId(token);
        if(loginId != null){
            // 这里可以根据用户登录id，查询是否具有管理报表的权限
            // 暂时未实现。2023-03-09
            logger.debug("......... loginId={}", loginId);
            return true;
        }
        return false;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    private String getLoginId(String token){
        try {
            String data = tokenGenerator.validateToken(token, VariableConstants.TOKEN_SECRET);
            String[] userIdAndKey = TokenUtils.getUserIdAndKey(data);
            return userIdAndKey[1];
        } catch (TokenException e) {
            e.printStackTrace();
            return null;
//            throw new RuntimeException(e);
        }
    }

    private TokenGenerator tokenGenerator;
}
