package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_SCHEDULER *
 * @author genrator
 */
public class S_scheduler_mapper extends S_scheduler implements BaseMapper<S_scheduler> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_scheduler> ROW_MAPPER = new S_schedulerRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String NAME = "name";
    public static final String STATUS = "status";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String INTERVAL_TIME = "interval_time";
    public static final String SLEEP_TIME = "sleep_time";
    public static final String SLEEP_OPTION = "sleep_option";
    public static final String PERIOD_TYPE = "period_type";
    public static final String TIME_TYPE = "time_type";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    public static final String RANGES = "ranges";
    public static final String DEPT = "dept";
    public static final String CLASS_NAME = "class_name";
    public static final String PAUSE_TIME = "pause_time";
    public static final String SUMMARY = "summary";

    /**
     * 默认构造函数
     */
    public S_scheduler_mapper(S_scheduler s_scheduler) {
        if (s_scheduler == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_scheduler.isset_id) {
            this.setId(s_scheduler.getId());
        }
        //普通属性
        if (s_scheduler.isset_create_time) {
            this.setCreate_time(s_scheduler.getCreate_time());
        }
        if (s_scheduler.isset_name) {
            this.setName(s_scheduler.getName());
        }
        if (s_scheduler.isset_status) {
            this.setStatus(s_scheduler.getStatus());
        }
        if (s_scheduler.isset_start_time) {
            this.setStart_time(s_scheduler.getStart_time());
        }
        if (s_scheduler.isset_end_time) {
            this.setEnd_time(s_scheduler.getEnd_time());
        }
        if (s_scheduler.isset_interval_time) {
            this.setInterval_time(s_scheduler.getInterval_time());
        }
        if (s_scheduler.isset_sleep_time) {
            this.setSleep_time(s_scheduler.getSleep_time());
        }
        if (s_scheduler.isset_sleep_option) {
            this.setSleep_option(s_scheduler.getSleep_option());
        }
        if (s_scheduler.isset_period_type) {
            this.setPeriod_type(s_scheduler.getPeriod_type());
        }
        if (s_scheduler.isset_time_type) {
            this.setTime_type(s_scheduler.getTime_type());
        }
        if (s_scheduler.isset_year) {
            this.setYear(s_scheduler.getYear());
        }
        if (s_scheduler.isset_month) {
            this.setMonth(s_scheduler.getMonth());
        }
        if (s_scheduler.isset_day) {
            this.setDay(s_scheduler.getDay());
        }
        if (s_scheduler.isset_hour) {
            this.setHour(s_scheduler.getHour());
        }
        if (s_scheduler.isset_ranges) {
            this.setRanges(s_scheduler.getRanges());
        }
        if (s_scheduler.isset_dept) {
            this.setDept(s_scheduler.getDept());
        }
        if (s_scheduler.isset_class_name) {
            this.setClass_name(s_scheduler.getClass_name());
        }
        if (s_scheduler.isset_pause_time) {
            this.setPause_time(s_scheduler.getPause_time());
        }
        if (s_scheduler.isset_summary) {
            this.setSummary(s_scheduler.getSummary());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_scheduler.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_scheduler";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ib.set(END_TIME, this.getEnd_time(), this.isset_end_time);
        ib.set(INTERVAL_TIME, this.getInterval_time(), this.isset_interval_time);
        ib.set(SLEEP_TIME, this.getSleep_time(), this.isset_sleep_time);
        ib.set(SLEEP_OPTION, this.getSleep_option(), this.isset_sleep_option);
        ib.set(PERIOD_TYPE, this.getPeriod_type(), this.isset_period_type);
        ib.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ib.set(YEAR, this.getYear(), this.isset_year);
        ib.set(MONTH, this.getMonth(), this.isset_month);
        ib.set(DAY, this.getDay(), this.isset_day);
        ib.set(HOUR, this.getHour(), this.isset_hour);
        ib.set(RANGES, this.getRanges(), this.isset_ranges);
        ib.set(DEPT, this.getDept(), this.isset_dept);
        ib.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ib.set(PAUSE_TIME, this.getPause_time(), this.isset_pause_time);
        ib.set(SUMMARY, this.getSummary(), this.isset_summary);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(END_TIME, this.getEnd_time(), this.isset_end_time);
        ub.set(INTERVAL_TIME, this.getInterval_time(), this.isset_interval_time);
        ub.set(SLEEP_TIME, this.getSleep_time(), this.isset_sleep_time);
        ub.set(SLEEP_OPTION, this.getSleep_option(), this.isset_sleep_option);
        ub.set(PERIOD_TYPE, this.getPeriod_type(), this.isset_period_type);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(YEAR, this.getYear(), this.isset_year);
        ub.set(MONTH, this.getMonth(), this.isset_month);
        ub.set(DAY, this.getDay(), this.isset_day);
        ub.set(HOUR, this.getHour(), this.isset_hour);
        ub.set(RANGES, this.getRanges(), this.isset_ranges);
        ub.set(DEPT, this.getDept(), this.isset_dept);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(PAUSE_TIME, this.getPause_time(), this.isset_pause_time);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(END_TIME, this.getEnd_time(), this.isset_end_time);
        ub.set(INTERVAL_TIME, this.getInterval_time(), this.isset_interval_time);
        ub.set(SLEEP_TIME, this.getSleep_time(), this.isset_sleep_time);
        ub.set(SLEEP_OPTION, this.getSleep_option(), this.isset_sleep_option);
        ub.set(PERIOD_TYPE, this.getPeriod_type(), this.isset_period_type);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(YEAR, this.getYear(), this.isset_year);
        ub.set(MONTH, this.getMonth(), this.isset_month);
        ub.set(DAY, this.getDay(), this.isset_day);
        ub.set(HOUR, this.getHour(), this.isset_hour);
        ub.set(RANGES, this.getRanges(), this.isset_ranges);
        ub.set(DEPT, this.getDept(), this.isset_dept);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(PAUSE_TIME, this.getPause_time(), this.isset_pause_time);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(END_TIME, this.getEnd_time(), this.isset_end_time);
        ub.set(INTERVAL_TIME, this.getInterval_time(), this.isset_interval_time);
        ub.set(SLEEP_TIME, this.getSleep_time(), this.isset_sleep_time);
        ub.set(SLEEP_OPTION, this.getSleep_option(), this.isset_sleep_option);
        ub.set(PERIOD_TYPE, this.getPeriod_type(), this.isset_period_type);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(YEAR, this.getYear(), this.isset_year);
        ub.set(MONTH, this.getMonth(), this.isset_month);
        ub.set(DAY, this.getDay(), this.isset_day);
        ub.set(HOUR, this.getHour(), this.isset_hour);
        ub.set(RANGES, this.getRanges(), this.isset_ranges);
        ub.set(DEPT, this.getDept(), this.isset_dept);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(PAUSE_TIME, this.getPause_time(), this.isset_pause_time);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, name, status, start_time, end_time, interval_time, sleep_time, sleep_option, period_type, time_type, year, month, day, hour, ranges, dept, class_name, pause_time, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, name, status, start_time, end_time, interval_time, sleep_time, sleep_option, period_type, time_type, year, month, day, hour, ranges, dept, class_name, pause_time, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_scheduler mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_scheduler toS_scheduler() {
        return super.$clone();
    }
}

/**
 * s_scheduler RowMapper
 *
 * @author genrator
 */
class S_schedulerRowMapper implements RowMapper<S_scheduler> {

    @Override
    public S_scheduler mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_scheduler s_scheduler = new S_scheduler();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.ID);
        if (columnIndex > 0) {
            s_scheduler.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setCreate_time(null);
            } else {
                s_scheduler.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.NAME);
        if (columnIndex > 0) {
            s_scheduler.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setStatus(null);
            } else {
                s_scheduler.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.START_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setStart_time(null);
            } else {
                s_scheduler.setStart_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.END_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setEnd_time(null);
            } else {
                s_scheduler.setEnd_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.INTERVAL_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setInterval_time(null);
            } else {
                s_scheduler.setInterval_time(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.SLEEP_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setSleep_time(null);
            } else {
                s_scheduler.setSleep_time(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.SLEEP_OPTION);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setSleep_option(null);
            } else {
                s_scheduler.setSleep_option(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.PERIOD_TYPE);
        if (columnIndex > 0) {
            s_scheduler.setPeriod_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.TIME_TYPE);
        if (columnIndex > 0) {
            s_scheduler.setTime_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.YEAR);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setYear(null);
            } else {
                s_scheduler.setYear(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.MONTH);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setMonth(null);
            } else {
                s_scheduler.setMonth(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.DAY);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setDay(null);
            } else {
                s_scheduler.setDay(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.HOUR);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setHour(null);
            } else {
                s_scheduler.setHour(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.RANGES);
        if (columnIndex > 0) {
            s_scheduler.setRanges(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.DEPT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setDept(null);
            } else {
                s_scheduler.setDept(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.CLASS_NAME);
        if (columnIndex > 0) {
            s_scheduler.setClass_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.PAUSE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_scheduler.setPause_time(null);
            } else {
                s_scheduler.setPause_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_scheduler_mapper.SUMMARY);
        if (columnIndex > 0) {
            s_scheduler.setSummary(rs.getString(columnIndex));
        }
        return s_scheduler;
    }
}
