package com.iplatform.scheduler;

import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.support.MemoryScheduleEngine;
import com.walker.scheduler.ScheduleEngine;

import java.util.List;

/**
 * 基于内存调度管理器实现，调度任务不存储数据库，仅在内存中。
 * @author 时克英
 * @date 2022-09-08
 */
public class MemorySchedulerManager extends PlatformSchedulerManager{

    private MemoryScheduleEngine scheduleEngine;

    public void setScheduleEngine(MemoryScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    @Override
    protected List<S_scheduler> acquireRunningList() {
        logger.warn("内存实现的调度管理器: 无法在启动时初始化未完成任务! 系统停止则所有任务也终止，重启后无法自动重启任务，若要实现"
                + "自动重启需要配置为(DatabaseSchedulerManager)");
        return null;
    }

    @Override
    protected ScheduleEngine acquireScheduleEngine() {
        if(this.scheduleEngine == null){
            throw new IllegalArgumentException("请设置:MemoryScheduleEngine");
        }
        return this.scheduleEngine;
    }
}
