package com.iplatform.scheduler.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.scheduler.DatabaseSchedulerManager;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.iplatform.scheduler.support.DatabaseScheduleEngine;
import com.walker.jdbc.JdbcInspector;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass({JdbcInspector.class})
@ConditionalOnProperty(prefix = "iplatform.scheduler", name = "enabled", havingValue = "true", matchIfMissing = false)
public class DatabaseSchedulerConfig extends PlatformConfiguration {

    @Bean
    public SchedulerManagerProperties schedulerManagerProperties(){
        return new SchedulerManagerProperties();
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 初始化基于数据库的实现对象。2022-09-08
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    @Bean
//    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "true", matchIfMissing = false)
    public DatabaseScheduleEngine databaseScheduleEngine(SchedulerServiceImpl schedulerService){
        DatabaseScheduleEngine scheduleEngine = new DatabaseScheduleEngine();
        scheduleEngine.setSchedulerService(schedulerService);
        return scheduleEngine;
    }

    @Bean
//    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "true", matchIfMissing = false)
    public DatabaseSchedulerManager databaseSchedulerManager(DatabaseScheduleEngine scheduleEngine
            , SchedulerServiceImpl schedulerService){
        DatabaseSchedulerManager schedulerManager = new DatabaseSchedulerManager();
        schedulerManager.setSchedulerService(schedulerService);
        schedulerManager.setScheduleEngine((DatabaseScheduleEngine) scheduleEngine);
        logger.info("创建了 DatabaseSchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
        schedulerManager.startup();
        return schedulerManager;
    }
}
