package com.iplatform.scheduler.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.scheduler.MemorySchedulerManager;
import com.iplatform.scheduler.support.MemoryScheduleEngine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 如果没有引入包: walker-jdbc 则默认使用内存方式管理调度器。
 * @author 时克英
 * @date 2022-09-22
 */
@Configuration
@ConditionalOnProperty(prefix = "iplatform.scheduler", name = "enabled", havingValue = "true", matchIfMissing = true)
@ConditionalOnMissingClass("com.walker.jdbc.JdbcInspector")
public class LocalSchedulerConfig extends PlatformConfiguration {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 初始化基于内存的实现对象。2022-09-08
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    @Bean
//    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "false", matchIfMissing = false)
    public MemoryScheduleEngine memoryScheduleEngine(){
        return new MemoryScheduleEngine();
    }

    @Bean
//    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "false", matchIfMissing = false)
    public MemorySchedulerManager memorySchedulerManager(MemoryScheduleEngine scheduleEngine){
        MemorySchedulerManager schedulerManager = new MemorySchedulerManager();
        schedulerManager.setScheduleEngine((MemoryScheduleEngine) scheduleEngine);
        logger.info("创建了 MemorySchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
        schedulerManager.startup();
        return schedulerManager;
    }
}
