package com.iplatform.scheduler.config;

import com.iplatform.scheduler.DatabaseSchedulerManager;
import com.iplatform.scheduler.MemorySchedulerManager;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.iplatform.scheduler.support.DatabaseScheduleEngine;
import com.iplatform.scheduler.support.MemoryScheduleEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

//@Configuration
//@ConditionalOnProperty(prefix = "iplatform.scheduler", name = "enabled", havingValue = "true", matchIfMissing = false)
@Deprecated
public class SchedulerManagerConfig {

    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    private SchedulerServiceImpl schedulerService;

    @Autowired(required = false)
    public SchedulerManagerConfig(SchedulerServiceImpl schedulerService){
        this.schedulerService = schedulerService;
    }

    @Bean
    public SchedulerManagerProperties schedulerManagerProperties(){
        return new SchedulerManagerProperties();
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 初始化基于数据库的实现对象。2022-09-08
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    @Bean
    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "true", matchIfMissing = false)
    public DatabaseScheduleEngine databaseScheduleEngine(){
        DatabaseScheduleEngine scheduleEngine = new DatabaseScheduleEngine();
        scheduleEngine.setSchedulerService(this.schedulerService);
        return scheduleEngine;
    }

    @Bean
    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "true", matchIfMissing = false)
    public DatabaseSchedulerManager databaseSchedulerManager(DatabaseScheduleEngine scheduleEngine){
        DatabaseSchedulerManager schedulerManager = new DatabaseSchedulerManager();
        schedulerManager.setSchedulerService(this.schedulerService);
        schedulerManager.setScheduleEngine((DatabaseScheduleEngine) scheduleEngine);
        logger.info("创建了 DatabaseSchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
        schedulerManager.startup();
        return schedulerManager;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 初始化基于内存的实现对象。2022-09-08
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    @Bean
    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "false", matchIfMissing = false)
    public MemoryScheduleEngine memoryScheduleEngine(){
        return new MemoryScheduleEngine();
    }

    @Bean
    @ConditionalOnProperty(prefix = "iplatform.scheduler", name = "database-enabled", havingValue = "false", matchIfMissing = false)
    public MemorySchedulerManager memorySchedulerManager(MemoryScheduleEngine scheduleEngine){
        MemorySchedulerManager schedulerManager = new MemorySchedulerManager();
            schedulerManager.setScheduleEngine((MemoryScheduleEngine) scheduleEngine);
            logger.info("创建了 MemorySchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
            schedulerManager.startup();
            return schedulerManager;
    }
//    @Bean
//    public ScheduleEngine scheduleEngine(SchedulerManagerProperties schedulerManagerProperties){
//        if(schedulerManagerProperties.getDatabaseEnabled()){
//            DatabaseScheduleEngine scheduleEngine = new DatabaseScheduleEngine();
//            scheduleEngine.setSchedulerService(this.schedulerService);
//            return scheduleEngine;
//        } else {
//            return new MemoryScheduleEngine();
//        }
//    }
//
//    @Bean
//    public PlatformSchedulerManager platformSchedulerManager(ScheduleEngine scheduleEngine
//            , SchedulerManagerProperties schedulerManagerProperties){
//        if(schedulerManagerProperties.getDatabaseEnabled()){
//            DatabaseSchedulerManager schedulerManager = new DatabaseSchedulerManager();
//            schedulerManager.setSchedulerService(this.schedulerService);
//            schedulerManager.setScheduleEngine((DatabaseScheduleEngine) scheduleEngine);
//            logger.info("创建了 DatabaseSchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
//            schedulerManager.startup();
//            return schedulerManager;
//        } else {
//            MemorySchedulerManager schedulerManager = new MemorySchedulerManager();
//            schedulerManager.setScheduleEngine((MemoryScheduleEngine) scheduleEngine);
//            logger.info("创建了 MemorySchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
//            schedulerManager.startup();
//            return schedulerManager;
//        }
//    }
}
