package com.iplatform.scheduler.service;

import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.Constants;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 调度任务数据库操作。
 * @author 时克英
 * @date 2022-09-07
 */
@Service
public class SchedulerServiceImpl extends BaseServiceImpl {

    private static final String SQL_PAGE_LIST_SEARCH = "select * from s_scheduler where dept=0 or dept=:dept order by create_time desc";
    private static final String SQL_PAGE_LIST = "select * from s_scheduler order by create_time desc";

    public GenericPager<S_scheduler> queryPageSchedulerList(long dept){
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if(dept < 0){
            return this.selectSplit(SQL_PAGE_LIST, new Object[]{}, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_scheduler());
        }
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("dept", dept);
        return this.selectSplit(SQL_PAGE_LIST_SEARCH, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_scheduler());
    }

    /**
     * 查询正在运行（包含：暂停的）状态的调度器记录
     * @return
     */
    public List<S_scheduler> queryRunningSchedulers(){
        return this.select(new S_scheduler(), "where status >= ? and status <= ?", new Object[]{1,2});
    }

    /**
     * 调度器启动，状态更新
     * @param id
     */
    public void execUpdateSchedulerStarted(int id){
        S_scheduler e = new S_scheduler();
        e.setStatus(Constants.STATUS_START);
        e.setStart_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    /**
     * 调度器（手动）停止，状态更新
     * @param id
     */
    public void execUpdateSchedulerStopped(int id){
        S_scheduler e = new S_scheduler();
        e.setStatus(Constants.STATUS_TERMINATE);
        e.setEnd_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    /**
     * 调度器暂停，状态更新
     * @param id
     */
    public void execUpdateSchedulerPause(int id){
        S_scheduler e = new S_scheduler();
        e.setStatus(Constants.STATUS_PAUSE);
        e.setPause_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    /**
     * 调度器运行完成，状态更新
     * @param id
     */
    public void execUpdateSchedulerDone(int id){
        S_scheduler e = new S_scheduler();
        e.setStatus(Constants.STATUS_END);
        e.setEnd_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    public void execTestTransaction(boolean throwError){
        this.execUpdateSchedulerPause(1);
        if(throwError){
            throw new IllegalArgumentException("抛出测试异常，第一条数据应当无法更新");
        }
        this.execUpdateSchedulerPause(2);
    }

//    private static final String SQL_UPD_STATUS_STARTED = "update s_scheduler set status=1, start_time=? where id=?";
//    private static final String SQL_UPD_STATUS_STOPED = "update s_scheduler set status=-1, end_time=? where id=?";
//    private static final String SQL_UPD_STATUS_PAUSE = "update s_scheduler set status=2, pause_time=? where id=?";
//    private static final String SQL_UPD_STATUS_DONE = "update s_scheduler set status=9, end_time=? where id=?";
}
