package com.iplatform.scheduler.support;

import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.walker.scheduler.ScheduleEngine;

/**
 * 基于数据库的调度引擎实现。
 * @author 时克英
 * @date 2022-09-08
 */
public class DatabaseScheduleEngine implements ScheduleEngine {

    private SchedulerServiceImpl schedulerService;

    public void setSchedulerService(SchedulerServiceImpl schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public void setStatusStarted(int scheduleId) {
        this.schedulerService.execUpdateSchedulerStarted(scheduleId);
    }

    @Override
    public void setStatusRestarted(int scheduleId) {
        this.schedulerService.execUpdateSchedulerStarted(scheduleId);
    }

    @Override
    public void setStatusPaused(int scheduleId) {
        this.schedulerService.execUpdateSchedulerPause(scheduleId);
    }

    @Override
    public void setStatusStoped(int scheduleId) {
        this.schedulerService.execUpdateSchedulerStopped(scheduleId);
    }

    @Override
    public void setStatusDone(int scheduleId) {
        this.schedulerService.execUpdateSchedulerDone(scheduleId);
    }
}
