/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.scheduler;

import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.util.SchedulerUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.scheduler.AbstractScheduler;
import com.walker.scheduler.GatherSchedulerManager;
import com.walker.scheduler.ScheduleEngine;
import com.walker.scheduler.impl.TimedScheduler;
import com.walker.security.SystemLogMan;
import java.util.List;

public abstract class PlatformSchedulerManager
extends GatherSchedulerManager {
    private ScheduleEngine scheduleEngine;

    public void startup() {
        this.initialize();
    }

    protected void initialize() {
        this.scheduleEngine = this.acquireScheduleEngine();
        if (this.scheduleEngine == null) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u4e00\u4e2a\u53ef\u7528\u7684\u8c03\u5ea6\u5f15\u64ce\u5bf9\u8c61: ScheduleEngine");
        }
        SystemLogMan.getInstance().checkMan();
        List<S_scheduler> schedulerList = this.acquireRunningList();
        int count = 0;
        if (!StringUtils.isEmptyList(schedulerList)) {
            boolean result = false;
            for (S_scheduler e : schedulerList) {
                if (e.getStatus() == 1) {
                    result = this.runScheduler(e);
                    if (!result) {
                        this.logger.info("\u4e00\u4e2a\u8c03\u5ea6\u5668\u521d\u59cb\u5316\u8fd0\u884c\u5931\u8d25:" + e.getId());
                        continue;
                    }
                    ++count;
                    continue;
                }
                if (e.getStatus() != 2) continue;
                this.putPauseScheduler(e);
            }
        }
        this.logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.logger.info("\u521d\u59cb\u5316\u4e86\u8c03\u5ea6\u7ba1\u7406\u5668\uff0c\u52a0\u8f7d\u5df2\u6709\u8c03\u5ea6\u4efb\u52a1:" + count + "\u4e2a");
        this.logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    protected boolean runScheduler(S_scheduler entity) {
        try {
            TimedScheduler scheduler = SchedulerUtils.createScheduler(entity, this.scheduleEngine);
            this.startScheduler((AbstractScheduler)scheduler);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u542f\u52a8\u540e\uff0c\u81ea\u52a8\u8fd0\u884c\u8c03\u5ea6\u5668\u9519\u8bef\uff1a" + entity.getName() + "\uff0cid=" + entity.getId(), (Throwable)e);
            return false;
        }
    }

    protected TimedScheduler putPauseScheduler(S_scheduler e) {
        try {
            TimedScheduler scheduler = SchedulerUtils.createScheduler(e, this.scheduleEngine);
            scheduler.pause();
            this.getCachedData().put(Integer.valueOf(e.getId()), scheduler);
            return scheduler;
        }
        catch (Exception e1) {
            this.logger.error("\u7cfb\u7edf\u542f\u52a8\u540e\uff0c\u521b\u5efa\u8c03\u5ea6\u5668\u9519\u8bef\uff1a" + e.getName() + "\uff0cid=" + e.getId(), (Throwable)e1);
            return null;
        }
    }

    public ScheduleEngine getScheduleEngine() {
        return this.scheduleEngine;
    }

    protected abstract List<S_scheduler> acquireRunningList();

    protected abstract ScheduleEngine acquireScheduleEngine();
}

