/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.scheduler.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.scheduler.DatabaseSchedulerManager;
import com.iplatform.scheduler.config.SchedulerManagerProperties;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.iplatform.scheduler.support.DatabaseScheduleEngine;
import com.walker.jdbc.JdbcInspector;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={JdbcInspector.class})
@ConditionalOnProperty(prefix="iplatform.scheduler", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DatabaseSchedulerConfig
extends PlatformConfiguration {
    @Bean
    public SchedulerManagerProperties schedulerManagerProperties() {
        return new SchedulerManagerProperties();
    }

    @Bean
    public DatabaseScheduleEngine databaseScheduleEngine(SchedulerServiceImpl schedulerService) {
        DatabaseScheduleEngine scheduleEngine = new DatabaseScheduleEngine();
        scheduleEngine.setSchedulerService(schedulerService);
        return scheduleEngine;
    }

    @Bean
    public DatabaseSchedulerManager databaseSchedulerManager(DatabaseScheduleEngine scheduleEngine, SchedulerServiceImpl schedulerService) {
        DatabaseSchedulerManager schedulerManager = new DatabaseSchedulerManager();
        schedulerManager.setSchedulerService(schedulerService);
        schedulerManager.setScheduleEngine(scheduleEngine);
        this.logger.info("\u521b\u5efa\u4e86 DatabaseSchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
        schedulerManager.startup();
        return schedulerManager;
    }
}

