/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.scheduler.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.scheduler.MemorySchedulerManager;
import com.iplatform.scheduler.support.MemoryScheduleEngine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iplatform.scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingClass(value={"com.walker.jdbc.JdbcInspector"})
public class LocalSchedulerConfig
extends PlatformConfiguration {
    @Bean
    public MemoryScheduleEngine memoryScheduleEngine() {
        return new MemoryScheduleEngine();
    }

    @Bean
    public MemorySchedulerManager memorySchedulerManager(MemoryScheduleEngine scheduleEngine) {
        MemorySchedulerManager schedulerManager = new MemorySchedulerManager();
        schedulerManager.setScheduleEngine(scheduleEngine);
        this.logger.info("\u521b\u5efa\u4e86 MemorySchedulerManager, scheduleEngine=" + scheduleEngine.getClass().getName());
        schedulerManager.startup();
        return schedulerManager;
    }
}

