/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.scheduler.service;

import com.iplatform.model.po.S_scheduler;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SchedulerServiceImpl
extends BaseServiceImpl {
    private static final String SQL_PAGE_LIST_SEARCH = "select * from s_scheduler where dept=0 or dept=:dept order by create_time desc";
    private static final String SQL_PAGE_LIST = "select * from s_scheduler order by create_time desc";

    public GenericPager<S_scheduler> queryPageSchedulerList(long dept) {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (dept < 0L) {
            return this.selectSplit(SQL_PAGE_LIST, new Object[0], pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_scheduler());
        }
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("dept", dept);
        return this.selectSplit(SQL_PAGE_LIST_SEARCH, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_scheduler());
    }

    public List<S_scheduler> queryRunningSchedulers() {
        return this.select(new S_scheduler(), "where status >= ? and status <= ?", new Object[]{1, 2});
    }

    public void execUpdateSchedulerStarted(int id) {
        S_scheduler e = new S_scheduler();
        e.setStatus(1);
        e.setStart_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    public void execUpdateSchedulerStopped(int id) {
        S_scheduler e = new S_scheduler();
        e.setStatus(-1);
        e.setEnd_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    public void execUpdateSchedulerPause(int id) {
        S_scheduler e = new S_scheduler();
        e.setStatus(2);
        e.setPause_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    public void execUpdateSchedulerDone(int id) {
        S_scheduler e = new S_scheduler();
        e.setStatus(9);
        e.setEnd_time(Long.parseLong(DateUtils.getDateTimeSecondForShow()));
        this.update(e, "where id=?", new Object[]{id});
    }

    public void execTestTransaction(boolean throwError) {
        this.execUpdateSchedulerPause(1);
        if (throwError) {
            throw new IllegalArgumentException("\u629b\u51fa\u6d4b\u8bd5\u5f02\u5e38\uff0c\u7b2c\u4e00\u6761\u6570\u636e\u5e94\u5f53\u65e0\u6cd5\u66f4\u65b0");
        }
        this.execUpdateSchedulerPause(2);
    }
}

