/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.scheduler.util;

import com.iplatform.model.po.S_scheduler;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.scheduler.Option;
import com.walker.scheduler.ScheduleEngine;
import com.walker.scheduler.impl.ForeverScheduler;
import com.walker.scheduler.impl.TimedScheduler;
import com.walker.scheduler.util.OptionUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class SchedulerUtils {
    public static final Option combineOption(S_scheduler schedule) {
        Option option = new Option();
        if (schedule.getTime_type().equals(Option.TimeType.RANGE.getIndex())) {
            String[] ranges = schedule.getRanges().split(";");
            if (ranges == null || ranges.length == 0) {
                throw new IllegalArgumentException("\u65f6\u95f4\u6bb5\u8303\u56f4\u4e0d\u5b58\u5728\uff0c\u8f93\u5165\u9519\u8bef\uff1a" + schedule.getRanges());
            }
            ArrayList<Integer[]> timeRanges = new ArrayList<Integer[]>(ranges.length);
            for (String r : ranges) {
                String[] array = r.split(",");
                if (array.length != 2) {
                    throw new IllegalArgumentException("\u65f6\u95f4\u6570\u7ec4\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u4e24\u4e2a\u6570\u5b57");
                }
                timeRanges.add(new Integer[]{Integer.parseInt(array[0]), Integer.parseInt(array[1])});
            }
            option.setRangeTime(timeRanges);
        }
        option.setTimeType(Option.TimeType.getObject((String)schedule.getTime_type()));
        option.setPeriodType(Option.PeriodType.getObject((String)schedule.getPeriod_type()));
        option.setExactlyTime(schedule.getYear().intValue(), schedule.getMonth().intValue(), schedule.getDay().intValue(), schedule.getHour().intValue());
        return option;
    }

    public static final TimedScheduler createScheduler(S_scheduler schedule, ScheduleEngine schedulerEngine) throws Exception {
        Class schedulerClass = ClassUtils.forName((String)schedule.getClass_name(), (ClassLoader)SchedulerUtils.class.getClassLoader());
        Constructor constructor = schedulerClass.getConstructor(Integer.TYPE, String.class);
        TimedScheduler listeningScheduler = (TimedScheduler)constructor.newInstance((int)schedule.getId(), schedule.getName());
        listeningScheduler.setScheduleEngine(schedulerEngine);
        listeningScheduler.setMaxFailedTimes(3);
        listeningScheduler.setTaskTerminateCondition(false);
        listeningScheduler.setTimeInterval((long)schedule.getInterval_time().intValue());
        listeningScheduler.setWaitSleepTime((long)schedule.getSleep_time().intValue());
        if (listeningScheduler instanceof ForeverScheduler) {
            ForeverScheduler scheduler = (ForeverScheduler)listeningScheduler;
            scheduler.setOption(OptionUtils.combineEveryDay24HourOption());
        } else {
            listeningScheduler.setOption(SchedulerUtils.combineOption(schedule));
        }
        return listeningScheduler;
    }
}

