package com.iplatform.scheduler;

import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.iplatform.scheduler.support.DatabaseScheduleEngine;
import com.walker.scheduler.ScheduleEngine;

import java.util.List;

/**
 * 基于数据库的调度管理器实现。
 * @author 时克英
 * @date 2022-09-08
 */
public class DatabaseSchedulerManager extends PlatformSchedulerManager {

    private SchedulerServiceImpl schedulerService;

    private DatabaseScheduleEngine scheduleEngine;

    public void setScheduleEngine(DatabaseScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public void setSchedulerService(SchedulerServiceImpl schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    protected List<S_scheduler> acquireRunningList() {
        if(this.schedulerService == null){
            throw new IllegalArgumentException("请设置:SchedulerServiceImpl");
        }
        return this.schedulerService.queryRunningSchedulers();
    }

    @Override
    protected ScheduleEngine acquireScheduleEngine() {
        if(this.scheduleEngine == null){
            throw new IllegalArgumentException("请设置:DatabaseScheduleEngine");
        }
        return this.scheduleEngine;
    }
}
