package com.iplatform.scheduler.support;

import com.walker.scheduler.ScheduleEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryScheduleEngine implements ScheduleEngine {

    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setStatusStarted(int scheduleId) {
        logger.info("调度任务已启动:" + scheduleId);
    }

    @Override
    public void setStatusRestarted(int scheduleId) {
        logger.info("调度任务已重启:" + scheduleId);
    }

    @Override
    public void setStatusPaused(int scheduleId) {
        logger.info("调度任务已暂停:" + scheduleId);
    }

    @Override
    public void setStatusStoped(int scheduleId) {
        logger.info("调度任务已被终止:" + scheduleId);
    }

    @Override
    public void setStatusDone(int scheduleId) {
        logger.info("调度任务已完成:" + scheduleId);
    }
}
