package com.iplatform.scheduler.util;

import com.iplatform.model.po.S_scheduler;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.scheduler.Option;
import com.walker.scheduler.ScheduleEngine;
import com.walker.scheduler.impl.ForeverScheduler;
import com.walker.scheduler.impl.TimedScheduler;
import com.walker.scheduler.util.OptionUtils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class SchedulerUtils {

    /**
     * 根据数据库存储的调度信息记录，组装出来一个调度选项对象
     * @param schedule
     * @return
     */
    public static final Option combineOption(S_scheduler schedule){
        Option option = new Option();
        if(schedule.getTime_type().equals(Option.TimeType.RANGE.getIndex())){
            String[] ranges = schedule.getRanges().split(StringUtils.SEPARATOR_SEMI_COLON);
            if(ranges == null || ranges.length == 0){
                throw new IllegalArgumentException("时间段范围不存在，输入错误：" + schedule.getRanges());
            }

            List<Integer[]> timeRanges = new ArrayList<Integer[]>(ranges.length);

            for(String r : ranges){
                String[] array = r.split(StringUtils.DEFAULT_SPLIT_SEPARATOR);
                if(array.length != 2){
                    throw new IllegalArgumentException("时间数组错误，必须是两个数字");
                }
                timeRanges.add(new Integer[]{Integer.parseInt(array[0]), Integer.parseInt(array[1])});
            }
            option.setRangeTime(timeRanges);
        }

        option.setTimeType(Option.TimeType.getObject(schedule.getTime_type()));
        option.setPeriodType(Option.PeriodType.getObject(schedule.getPeriod_type()));
        option.setExactlyTime(schedule.getYear(), schedule.getMonth(), schedule.getDay(), schedule.getHour());
        return option;
    }

    /**
     * 创建一个调度器对象
     * @param schedule 数据库记录的调度器配置信息
     * @param schedulerEngine 调度引擎
     * @return
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static final TimedScheduler createScheduler(S_scheduler schedule, ScheduleEngine schedulerEngine) throws Exception{
        Class<?> schedulerClass = ClassUtils.forName(schedule.getClass_name(), SchedulerUtils.class.getClassLoader());
        Constructor<TimedScheduler> constructor = (Constructor<TimedScheduler>)schedulerClass.getConstructor(int.class, String.class);

        TimedScheduler listeningScheduler = constructor.newInstance(schedule.getId().intValue(), schedule.getName());
//		listeningScheduler.setScheduleEngine(new EmptySchedulerEngine());
        listeningScheduler.setScheduleEngine(schedulerEngine);
//        listeningScheduler.setId(schedule.getId().intValue());
//        listeningScheduler.setName(schedule.getName());
        listeningScheduler.setMaxFailedTimes(3);
        listeningScheduler.setTaskTerminateCondition(false);
        listeningScheduler.setTimeInterval(schedule.getInterval_time());
        listeningScheduler.setWaitSleepTime(schedule.getSleep_time());

        if(listeningScheduler instanceof ForeverScheduler){
            ForeverScheduler scheduler = (ForeverScheduler)listeningScheduler;
            scheduler.setOption(OptionUtils.combineEveryDay24HourOption());
        } else {
            listeningScheduler.setOption(combineOption(schedule));
        }
        return listeningScheduler;
    }

}
