package com.ishop.merchant;

import com.iplatform.base.Constants;
import com.iplatform.base.WechatBaseController;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.service.CouponServiceImpl;
import com.ishop.merchant.service.CouponUserServiceImpl;
import com.ishop.merchant.service.ExpressServiceImpl;
import com.ishop.merchant.service.MerchantApplyServiceImpl;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.service.MerchantServiceImpl;
import com.ishop.merchant.service.OrderInvoiceServiceImpl;
import com.ishop.merchant.service.OrderServiceImpl;
import com.ishop.merchant.service.PayServiceImpl;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.service.ProductDescriptionServiceImpl;
import com.ishop.merchant.service.ProductGuaranteeServiceImpl;
import com.ishop.merchant.service.ProductRelationServiceImpl;
import com.ishop.merchant.service.ProductRuleServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.ShippingTemplateServiceImpl;
import com.ishop.merchant.service.UserAddressServiceImpl;
import com.ishop.merchant.service.UserBalanceServiceImpl;
import com.ishop.merchant.service.UserBrokerageServiceImpl;
import com.ishop.merchant.service.UserRechargeServiceImpl;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantCategory;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbMerchantType;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.UserType;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 商户模块基础控制器。
 * @author 时克英
 * @date 2023-06-01
 */
public abstract class BaseController extends WechatBaseController {

    /**
     * 批量更新电商用户缓存。
     * @param userIds
     * @date 2023-09-25
     */
    protected void batchUpdateEbUserCache(List<Long> userIds){
        if(StringUtils.isEmptyList(userIds)){
            return;
        }
        List<EbUser> userList = this.getUserRegisterService().queryUserList(userIds);
        for(EbUser user : userList){
            this.getUserRegCache().update(user);
        }
    }

    /**
     * 获取订单发货单列表，平台、商户都可以用。
     * @param orderNo
     * @return
     * @date 2023-08-18
     */
    protected List<OrderInvoiceVo> acquireOrderInvoiceList(String orderNo){
        EbOrderInvoice param = new EbOrderInvoice();
        param.setOrderNo(orderNo);
        List<EbOrderInvoice> orderInvoiceList = this.getOrderInvoiceService().select(param);
        if(StringUtils.isEmptyList(orderInvoiceList)){
            return new ArrayList<>(1);
        }

        List<Long> invoiceIdList = orderInvoiceList.stream().map(EbOrderInvoice::getId).collect(Collectors.toList());
        List<EbOrderInvoiceDetail> orderInvoiceDetailList = this.getOrderInvoiceService().queryOrderInvoiceDetailList(invoiceIdList);
        if(StringUtils.isEmptyList(orderInvoiceDetailList)){
            return new ArrayList<>(1);
        }
//        Map<Long, EbOrderInvoice> cacheInvoice = new HashMap<>(4);
//        for(EbOrderInvoice e : orderInvoiceList){
//            cacheInvoice.put(e.getId(), e);
//        }

        List<OrderInvoiceVo> list = new ArrayList<>(4);
        OrderInvoiceVo vo = null;
        for(EbOrderInvoice e : orderInvoiceList){
            vo = VoUtils.acquireOrderInvoiceVo(e);
            for(EbOrderInvoiceDetail ed: orderInvoiceDetailList){
                if(ed.getInvoiceId().longValue() == vo.getId().longValue()){
                    vo.addDetailVo(VoUtils.acquireOrderInvoiceDetailVo(ed));
                }
            }
            list.add(vo);
        }
        return list;
    }

    /**
     * 获取通用平台订单详情信息，平台和商户都使用。
     * @param order
     * @param orderNo
     * @return
     * @date 2023-08-18
     */
    protected PlatformOrderDetailVo acquireCommonOrderDetail(EbOrder order, String orderNo){
        EbMerchantOrder merchantOrder = this.getOrderService().queryMerchantOrderOne(orderNo);
        List<EbOrderDetail> detailList = this.getOrderService().queryOrderDetailList(orderNo);

        EbUser user = this.getUserRegCache().get(order.getUid());
        EbMerchant merchant = this.getMerchantCache().get(merchantOrder.getMerId());
        PlatformOrderDetailVo vo = VoUtils.acquirePlatformOrderDetailVo(order, merchantOrder);
//        vo.setSplitOrderNo(mer);
//        vo.setExpressCode(or);
        vo.setNikeName(user.getNickname());
        vo.setRealName(user.getRealName());
        vo.setMerName(merchant.getName());
        vo.setIsLogoff(user.getIsLogoff().intValue() == 1);
        if(merchantOrder.getClerkId().longValue() > 0){
            vo.setClerkName(this.getUser(merchantOrder.getClerkId()).getNick_name());
        }

        List<OrderDetailFrontVo> orderDetailList = new ArrayList<>(detailList.size());
        for(EbOrderDetail detail : detailList){
            orderDetailList.add(VoUtils.acquireOrderDetailFrontVo(detail));
        }
        vo.setOrderDetailList(orderDetailList);
        return vo;
    }

    /**
     * 获取公共订单列表，目前后台和商户都可以使用该方法。
     * @param data
     * @return
     * @date 2023-08-18
     */
    protected List<PlatformOrderVo> acquireCommonOrderList(List<EbOrder> data){
        List<PlatformOrderVo> list = new ArrayList<>(data.size());
        PlatformOrderVo vo = null;
        EbUser user = null;
        EbMerchant merchant = null;
        for(EbOrder order : data){
            vo = VoUtils.acquirePlatformOrderVo(order);
            user = this.getUserRegCache().get(order.getUid());
            vo.setIsLogoff(user.getIsLogoff().intValue() == 1);
            vo.setNickName(user.getNickname());
            if(order.getMerId().intValue() > 0){
                merchant = this.getMerchantCache().get(order.getMerId());
                vo.setMerName(merchant.getName());
            }
            list.add(vo);
        }
        return list;
    }

    /**
     * 返回文章详细内容。
     * @param id 文字id
     * @return
     * @date 2023-08-09
     */
    protected ResponseValue acquireArticleDetailVo(Long id){
        if(id == null || id.longValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbArticle article = this.getArticleService().get(new EbArticle(id));
        if(article == null){
            return ResponseValue.success("文章不存在");
        }
        return ResponseValue.success(VoUtils.acquireArticleVo(article, getCdnUrl(), true));
    }

    /**
     * 当前登录用户是否超管（平台商户超管）
     * @return
     * @date 2023-06-18
     */
    protected boolean isPlatformSuper(){
        S_user_core user = this.getCurrentUser();
        int userType = user.getUser_type().intValue();
        if(userType == UserType.TYPE_SUPER || userType == UserType.TYPE_SUPER_MERCHANT){
            // 平台超管，平台商户超管
            return true;
        }
        return false;
    }

    /**
     * 当前登录用户是否商户。
     * @return
     * @date 2023-06-18
     */
    protected boolean isMerchant(){
        S_user_core user = this.getCurrentUser();
        int userType = user.getUser_type().intValue();
        if(userType == UserType.TYPE_MERCHANT_ADMIN){
            return true;
        }
        return false;
    }

    /**
     * 返回商户定义数据库服务
     * @return
     * @date 2023-06-01
     */
    protected MerchantServiceImpl getMerchantService(){
        return BeanContextAware.getBeanByType(MerchantServiceImpl.class);
    }

    protected MerchantApplyServiceImpl getMerchantApplyService(){
        return BeanContextAware.getBeanByType(MerchantApplyServiceImpl.class);
    }

    protected MerCategoryCacheProvider getMerchantCategoryCache(){
        return BeanContextAware.getBeanByType(MerCategoryCacheProvider.class);
    }

    protected MerTypeCacheProvider getMerchantTypeCache(){
        return BeanContextAware.getBeanByType(MerTypeCacheProvider.class);
    }

    protected String getMerchantCategoryName(int categoryId){
        EbMerchantCategory category = this.getMerchantCategoryCache().get(categoryId);
        if(category == null){
            logger.error("缓存中未找到'商户分类'：{}", categoryId);
            return StringUtils.EMPTY_STRING;
        }
        return category.getName();
    }

    protected String getMerchantTypeName(int typeId){
        EbMerchantType type = this.getMerchantTypeCache().get(typeId);
        if(type == null){
            logger.error("缓存中未找到'商户类别'：{}", typeId);
            return StringUtils.EMPTY_STRING;
        }
        return type.getName();
    }

    protected ProductCategoryServiceImpl getProductCategoryService(){
        return BeanContextAware.getBeanByType(ProductCategoryServiceImpl.class);
    }

    protected ProductCategoryCache getProductCategoryCache(){
        return BeanContextAware.getBeanByType(ProductCategoryCache.class);
    }

    protected ProductBrandServiceImpl getProductBrandService(){
        return BeanContextAware.getBeanByType(ProductBrandServiceImpl.class);
    }

    protected ProductBrandCache getProductBrandCache(){
        return BeanContextAware.getBeanByType(ProductBrandCache.class);
    }

    protected ProductServiceImpl getProductService(){
        return BeanContextAware.getBeanByType(ProductServiceImpl.class);
    }

    protected MerchantCache getMerchantCache(){
        return BeanContextAware.getBeanByType(MerchantCache.class);
    }

    protected ProductAttrCache getProductAttrCache(){
        return BeanContextAware.getBeanByType(ProductAttrCache.class);
    }

    protected ProductAttrValueServiceImpl getProductAttrValueService(){
        return BeanContextAware.getBeanByType(ProductAttrValueServiceImpl.class);
    }

    protected ProductDescriptionServiceImpl getProductDescriptionService(){
        return BeanContextAware.getBeanByType(ProductDescriptionServiceImpl.class);
    }

    protected MerchantProductCategoryServiceImpl getMerchantProductCategoryService(){
        return BeanContextAware.getBeanByType(MerchantProductCategoryServiceImpl.class);
    }

    protected MerProductCategoryCache getMerProductCategoryCache(){
        return BeanContextAware.getBeanByType(MerProductCategoryCache.class);
    }

    protected UserRegisterServiceImpl getUserRegisterService(){
        return BeanContextAware.getBeanByType(UserRegisterServiceImpl.class);
    }

    protected UserRegCache getUserRegCache(){
        return BeanContextAware.getBeanByType(UserRegCache.class);
    }

    /**
     * 根据注册用户ID，返回其名字（昵称）
     * @param id
     * @return
     */
    protected String getUserRegisterName(long id){
        EbUser user = this.getUserRegCache().get(id);
        if(user != null){
            return user.getNickname();
        }
        return StringUtils.EMPTY_STRING;
    }

    protected ShippingTemplateServiceImpl getShippingTemplateService(){
        return BeanContextAware.getBeanByType(ShippingTemplateServiceImpl.class);
    }

    protected ProductGuaranteeServiceImpl getProductGuaranteeService(){
        return BeanContextAware.getBeanByType(ProductGuaranteeServiceImpl.class);
    }

    protected CouponServiceImpl getCouponService(){
        return BeanContextAware.getBeanByType(CouponServiceImpl.class);
    }

    protected ArticleServiceImpl getArticleService(){
        return BeanContextAware.getBeanByType(ArticleServiceImpl.class);
    }

    protected CityCacheProvider getCityCache(){
        return BeanContextAware.getBeanByType(CityCacheProvider.class);
    }

    protected CityServiceImpl getCityService(){
        return BeanContextAware.getBeanByType(CityServiceImpl.class);
    }

    protected ProductRelationServiceImpl getProductRelationService(){
        return BeanContextAware.getBeanByType(ProductRelationServiceImpl.class);
    }

    protected CouponUserServiceImpl getCouponUserService(){
        return BeanContextAware.getBeanByType(CouponUserServiceImpl.class);
    }

    protected LevelCache getLevelCache(){
        return BeanContextAware.getBeanByType(LevelCache.class);
    }

    protected OrderServiceImpl getOrderService(){
        return BeanContextAware.getBeanByType(OrderServiceImpl.class);
    }

    protected UserAddressServiceImpl getUserAddressService(){
        return BeanContextAware.getBeanByType(UserAddressServiceImpl.class);
    }

    protected PayServiceImpl getPayService(){
        return BeanContextAware.getBeanByType(PayServiceImpl.class);
    }

    protected ArticleCategoryCache getArticleCategoryCache(){
        return BeanContextAware.getBeanByType(ArticleCategoryCache.class);
    }

    protected OrderInvoiceServiceImpl getOrderInvoiceService(){
        return BeanContextAware.getBeanByType(OrderInvoiceServiceImpl.class);
    }

    protected ProductCache getProductCache(){
        return BeanContextAware.getBeanByType(ProductCache.class);
    }

    protected ProductRuleServiceImpl getProductRuleService(){
        return BeanContextAware.getBeanByType(ProductRuleServiceImpl.class);
    }

    protected UserRegConfigServiceImpl getUserRegConfigService(){
        return BeanContextAware.getBeanByType(UserRegConfigServiceImpl.class);
    }

    protected UserRegConfigCache getUserRegConfigCache(){
        return BeanContextAware.getBeanByType(UserRegConfigCache.class);
    }

    protected ExpressCache getExpressCache(){
        return BeanContextAware.getBeanByType(ExpressCache.class);
    }

    protected ExpressServiceImpl getExpressService(){
        return BeanContextAware.getBeanByType(ExpressServiceImpl.class);
    }

    protected UserBalanceServiceImpl getUserBalanceService(){
        return BeanContextAware.getBeanByType(UserBalanceServiceImpl.class);
    }

    protected UserRechargeServiceImpl getUserRechargeService(){
        return BeanContextAware.getBeanByType(UserRechargeServiceImpl.class);
    }

    protected UserBrokerageServiceImpl getUserBrokerageService(){
        return BeanContextAware.getBeanByType(UserBrokerageServiceImpl.class);
    }

    /**
     * 返回当前电商注册用户（C端）
     * @return
     * @date 2023-07-09
     */
    protected EbUser getCurrentEbUser(){
        long userId = this.getCurrentUserId();
        return this.getUserRegCache().get(userId);
    }
}
