package com.ishop.merchant;

public class Constants {

    /** 商户审核状态-待审核 */
    public static final Integer AUDIT_STATUS_WAIT = 1;
    /** 商户审核状态-审核通过 */
    public static final Integer AUDIT_STATUS_SUCCESS = 2;
    /** 商户审核状态-审核拒绝 */
    public static final Integer AUDIT_STATUS_FAIL = 3;


    /** 计费方式：0-未知 */
    public static final int CHARGE_MODE_TYPE_UNKNOWN = 0;
    /** 计费方式：1-按件数 */
    public static final int CHARGE_MODE_TYPE_NUMBER = 1;
    /** 计费方式：2-按重量 */
    public static final int CHARGE_MODE_TYPE_WEIGHT = 2;
    /** 计费方式：3-按体积 */
    public static final int CHARGE_MODE_TYPE_VOLIME = 3;

    /** 包邮类型：0-全国包邮 */
    public static final Integer APPOINT_TYPE_ALL = 0;
    /** 包邮类型：1-部分包邮 */
    public static final Integer APPOINT_TYPE_PART = 1;
    /** 包邮类型：2-自定义 */
    public static final Integer APPOINT_TYPE_DEFINED = 2;

    /** 默认模板名称—全国包邮 */
    public static final String DEFAULT_NAME = "全国包邮";

    /** 运费模板ID（自定义）：无需发货，对于虚拟商品，购买后就完成 2023-09-09*/
    public static final int SHIPPING_TEMPLATE_ID_NO_SEND = -1;
    public static final String SHIPPING_TEMPLATE_NAME_NO_SEND = "虚拟商品无需发货";

    /** 创建类型-管理员创建 */
    public static final String CREATE_TYPE_ADMIN = "admin";
    /** 创建类型-入驻申请 */
    public static final String CREATE_TYPE_APPLY = "apply";

    /** 商户初始密码 */
    public static final String INIT_PASSWORD = "000000";

    /** 商户结算类型-银行卡 */
    public static final String MERCHANT_SETTLEMENT_TYPE_BANK = "bank";
    /** 商户结算类型-微信 */
    public static final String MERCHANT_SETTLEMENT_TYPE_WECHAT = "wechat";
    /** 商户结算类型-支付宝 */
    public static final String MERCHANT_SETTLEMENT_TYPE_ALIPAY = "alipay";

    /** 商户客服类型-H5 */
    public static final String MERCHANT_SERVICE_TYPE_H5 = "H5";
    /** 商户客服类型-Phone */
    public static final String MERCHANT_SERVICE_TYPE_PHONE = "phone";
    /** 商户客服类型-message */
    public static final String MERCHANT_SERVICE_TYPE_MESSAGE = "message";
    /** 商户客服类型-email */
    public static final String MERCHANT_SERVICE_TYPE_EMAIL = "email";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //~ 缓存常量定义。2023-06-06
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`

    public static final String CACHE_NAME_MER_CATEGORY = "cache.merchant.category";
    public static final String CACHE_NAME_MER_TYPE = "cache.merchant.type";
    public static final String CACHE_NAME_PRODUCT_CATEGORY = "cache.product.category";
    public static final String CACHE_NAME_PRODUCT_BRAND = "cache.product.brand";
    public static final String CACHE_NAME_MERCHANT = "cache.merchant";
    public static final String CACHE_NAME_PRODUCT_ATTR = "cache.product.attr";
    public static final String CACHE_NAME_PRODUCT = "cache.product";
    public static final String CACHE_NAME_MER_PRODUCT_CATEGORY = "cache.mer.product.cate";
    public static final String CACHE_NAME_USER_REG = "cache.user.reg";
    public static final String CACHE_NAME_CITY = "cache.city";
    public static final String CACHE_NAME_LEVEL = "cache.level";
    public static final String CACHE_NAME_ARTICLE_CATE = "cache.article.cate";
    public static final String CACHE_NAME_USER_CONFIG = "cache.user.config";
    public static final String CACHE_NAME_EXPRESS = "cache.express";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //~ 业务 参数配置常量定义。2023-06-30
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`

    /** 是否启用分销:1-启用，0-禁止 */
    public static final String RETAIL_STORE_SWITCH = "retail_store_switch";
    /** 分销额度：-1-指定分销，0--用户购买金额大于等于设置金额时，用户自动成为分销员 */
    public static final String RETAIL_STORE_LINE = "retail_store_line";
    /** 分销关系绑定:0-所有用户，1-新用户 */
    public static final String RETAIL_STORE_BINDING_TYPE = "retail_store_binding_type";
    /** 是否开启分销气泡 ：0-展示，1-展示*/
    public static final String RETAIL_STORE_BUBBLE_SWITCH = "retail_store_bubble_switch";
    /** 分销一级返佣比例 */
    public static final String RETAIL_STORE_BROKERAGE_FIRST_RATIO = "retail_store_brokerage_first_ratio";
    /** 分销二级返佣比例 */
    public static final String RETAIL_STORE_BROKERAGE_SECOND_RATIO = "retail_store_brokerage_second_ratio";
    /** 分销佣金冻结时间(天) */
    public static final String RETAIL_STORE_BROKERAGE_FREEZING_TIME = "retail_store_brokerage_freezing_time";
    /** 分销提现最低金额 */
    public static final String RETAIL_STORE_EXTRACT_MIN_PRICE = "retail_store_extract_min_price";
    /** 分销提现银行 */
    public static final String RETAIL_STORE_EXTRACT_BANK = "retail_store_extract_bank";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //~ 通用 配置常量定义。2023-07-05
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //升序排序
    public static final String SORT_ASC = "asc";
    //降序排序
    public static final String SORT_DESC = "desc";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //~ 订单常量定义。2023-07-05
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`

    public static final String PRE_ORDER_TYPE_SHOPPING_CART = "shoppingCart";
    public static final String PRE_ORDER_TYPE_BUY_NOW = "buyNow";
    public static final String PRE_ORDER_TYPE_VIDEO = "video";
    public static final String PRE_ORDER_TYPE_SECOND_KILL = "seckill";

    /** 积分抵扣开关 */
    public static final String CONFIG_KEY_INTEGRAL_DEDUCTION_SWITCH = "integral_deduction_switch";
    /** 积分抵扣开启金额(单位元),订单满多少钱可以使用积分抵扣 */
    public static final String CONFIG_KEY_INTEGRAL_DEDUCTION_START_MONEY = "integral_deduction_start_money";
    /** 积分抵扣金额(1积分抵多少金额，0.01) */
    public static final String CONFIG_KEY_INTEGRAL_DEDUCTION_MONEY = "integral_deduction_money";
    /** 积分抵扣比例(订单中积分可抵扣商品金额比例（0~100）%) */
    public static final String CONFIG_KEY_INTEGRAL_DEDUCTION_RATIO = "integral_deduction_ratio";
    /** 下单支付金额按比例赠送积分（实际支付多少元赠送1积分) */
    public static final String CONFIG_KEY_INTEGRAL_RATE_ORDER_GIVE = "order_give_integral";
    /** 积分冻结时间 */
    public static final String CONFIG_KEY_STORE_INTEGRAL_EXTRACT_TIME = "freeze_integral_day";

    /** 微信分享图片（公众号） */
    public static final String CONFIG_KEY_ADMIN_WECHAT_SHARE_IMAGE = "wechat_share_img";
    /** 微信分享标题（公众号） */
    public static final String CONFIG_KEY_ADMIN_WECHAT_SHARE_TITLE = "wechat_share_title";
    /** 微信分享简介（公众号） */
    public static final String CONFIG_KEY_ADMIN_WECHAT_SHARE_SYNOPSIS = "wechat_share_synopsis";

    /** 是否开启会员功能 */
    public static final String CONFIG_KEY_VIP_OPEN = "vip_open";
    /** 是否开启充值功能 */
    public static final String CONFIG_KEY_RECHARGE_SWITCH = "recharge_switch";
    /** 是否开启门店自提 */
    public static final String CONFIG_KEY_STORE_SELF_MENTION = "store_self_mention";
    /** 腾讯地图key */
    public static final String CONFIG_SITE_TENG_XUN_MAP_KEY = "tengxun_map_key";

    /** 操作类型-添加 */
    public static final String OPERATION_TYPE_ADD = "add";
    /** 操作类型-快捷添加 */
    public static final String OPERATION_TYPE_QUICK_ADD = "quick";
    /** 操作类型-扣减 */
    public static final String OPERATION_TYPE_SUBTRACT = "sub";
    /** 操作类型-活动创建 */
    public static final String OPERATION_TYPE_ACTIVITY_CREATE = "create";
    /** 操作类型-活动回归 */
    public static final String OPERATION_TYPE_ACTIVITY_ROLL_BACK = "back";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    //~ 分组配置常量定义。2023-07-12
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`

    /** 首页banner滚动图 */
    public static final Integer GROUP_DATA_ID_INDEX_BANNER = 1;
    /** 首页金刚区 */
    public static final Integer GROUP_DATA_ID_INDEX_MENU = 2;
    /** 热门搜索 */
    public static final Integer GROUP_DATA_ID_INDEX_KEYWORDS = 3;
    /** 移动端_充值套餐设置 */
    public static final Integer GROUP_DATA_ID_RECHARGE_PACKAGE = 4;
    /** 个人中心菜单 */
    public static final Integer GROUP_DATA_ID_USER_CENTER_MENU = 5;
    /** 个人中心轮播图 */
    public static final Integer GROUP_DATA_ID_USER_CENTER_BANNER = 7;
    /** 分销推广海报Banner */
    public static final Integer GROUP_DATA_ID_SPREAD_BANNER_LIST = 10;
    /** 移动端_订单状态_图 */
    public static final Integer GROUP_DATA_ID_ORDER_STATUS_IMAGE = 13;
    /** 移动端_底部导航 */
    public static final Integer GROUP_DATA_ID_BOTTOM_NAVIGATION = 14;

    /** 充值注意事项 */
    public static final String CONFIG_RECHARGE_ATTENTION = "recharge_attention";

    /** 用户最小充值金额 */
    public static final String USER_RECHARGE_MIN_AMOUNT = "store_user_min_recharge";

    /** 网站名称 */
    public static final String CONFIG_KEY_SITE_NAME = "site_name";

    /** 移动端域名 */
    public static final String CONFIG_KEY_SITE_URL = "site_url";

    /** 后台api地址(回调地址) */
    public static final String CONFIG_KEY_API_URL = "api_url";

    /**
     * =========================================================
     * UserToken部分
     * =========================================================
     */
    /** 用户Token类型——公众号 */
    public static final Integer USER_TOKEN_TYPE_WECHAT = 1;
    /** 用户Token类型——小程序 */
    public static final Integer USER_TOKEN_TYPE_ROUTINE = 2;
    /** 用户Token类型——微信ios */
    public static final Integer USER_TOKEN_TYPE_IOS_WX  = 5;
    /** 用户Token类型——微信android */
    public static final Integer USER_TOKEN_TYPE_ANDROID_WX = 6;
    /** 用户Token类型——ios */
    public static final Integer USER_TOKEN_TYPE_IOS  = 7;

    /** 注册类型——H5 */
    public static final String REGISTER_TYPE_H5 = "h5";
    /** 注册类型——公众号 */
    public static final String REGISTER_TYPE_WECHAT = "wechat";
    /** 注册类型——小程序 */
    public static final String REGISTER_TYPE_ROUTINE = "routine";
    /** 注册类型——微信ios */
    public static final String REGISTER_TYPE_IOS_WX = "iosWx";
    /** 注册类型——微信安卓 */
    public static final String REGISTER_TYPE_ANDROID_WX = "androidWx";
    /** 注册类型——ios */
    public static final String REGISTER_TYPE_IOS = "ios";

    /** 登录状态-登录 */
    public static final String LOGIN_STATUS_LOGIN = "login";
    /** 登录状态-注册 */
    public static final String LOGIN_STATUS_REGISTER = "register";
    /** 登录状态-注册起始页 */
    public static final String LOGIN_STATUS_START = "start";

    /**
     * =========================================================
     * 规格中，包含价格信息，用户线下支付，商品可根据规格，用户选择价格（或录入其他价格）
     * 2023-09-10
     * =========================================================
     */

    /** 规格名称关键词：价格 */
    public static final String ATTR_NAME_PRICE = "价格";
    /** 价格属性中，用户输入其他金额，选项名称 */
    public static final String ATTR_VALUE_OTHER_PRICE = "其他金额";
    @Deprecated
    public static final String ATTR_VALUE_CUSTOM_PRICE = "自定义";
}
