package com.ishop.merchant;

import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.vo.ProductCategoryVo;

import java.util.List;

/**
 * 商户商品分类缓存定义。
 * <pre>
 *     1)每个商户ID，组成 Key，商户定义商品类型集合为值（List）
 *     2)可以向每个集合（对应一个KEY）写入或删除元素
 *     3)集合缓存无法全部清空，只能一个一个删除或覆盖
 * </pre>
 * @author 时克英
 * @date 2023-06-15
 */
public interface MerProductCategoryCache {

    void putList(String key, List<EbMerchantProductCategory> data);

    void putList(String key, List<EbMerchantProductCategory> data, long expiredSeconds);

    void putListAppend(String key, EbMerchantProductCategory data);

    List<ProductCategoryVo> getTree(String key);

    List<EbMerchantProductCategory> getList(String key);

    void removeList(String key, EbMerchantProductCategory data);
}
