package com.ishop.merchant;

public class PayConstants {

    /** 微信支付开关 */
    public static final String CONFIG_PAY_WECHAT_OPEN = "pay_weixin_open";
    /** 余额支付状态 */
    public static final String CONFIG_YUE_PAY_STATUS  = "yue_pay_status";
    /** 支付宝支付状态 */
    public static final String CONFIG_ALI_PAY_STATUS = "ali_pay_status";

    /** 支付方式-微信支付 */
    public static final String PAY_TYPE_WE_CHAT = "weixin";
    /** 支付方式-余额支付 */
    public static final String PAY_TYPE_YUE = "yue";
    /** 支付方式-支付宝支付 */
    public static final String PAY_TYPE_ALI_PAY = "alipay";

    /** 支付服务类型-订单 */
    public static final String PAY_SERVICE_TYPE_ORDER = "order";
    /** 支付服务类型-充值 */
    public static final String PAY_SERVICE_TYPE_RECHARGE = "recharge";

    //微信支付接口请求地址
    public static final String WX_PAY_API_URL = "https://api.mch.weixin.qq.com/";
    // 微信统一预下单
    public static final String WX_PAY_API_URI = "pay/unifiedorder";
    // 微信查询订单
    public static final String WX_PAY_ORDER_QUERY_API_URI = "pay/orderquery";
    // 微信支付回调地址
    public static final String WX_PAY_NOTIFY_API_URI = "/pay/notify/wx_v2/orderNotify";
    // 微信退款回调地址
    public static final String WX_PAY_REFUND_NOTIFY_API_URI = "/api/publicly/payment/callback/wechat/refund";

    /** 支付渠道-公众号 */
    public static final String PAY_CHANNEL_WECHAT_PUBLIC = "public";
    /** 支付渠道-小程序 */
    public static final String PAY_CHANNEL_WECHAT_MINI = "mini";
    /** 支付渠道-视频号 */
    public static final String PAY_CHANNEL_WECHAT_MINI_VIDEO = "video";
    /** 支付渠道-网页支付 */
    public static final String PAY_CHANNEL_H5 = "h5";
    /** 支付渠道-余额支付 */
    public static final String PAY_CHANNEL_YUE = "yue";
    /** 支付渠道-微信Ios */
    public static final String PAY_CHANNEL_WECHAT_APP_IOS = "wechatIos";
    /** 支付渠道-微信Android */
    public static final String PAY_CHANNEL_WECHAT_APP_ANDROID = "wechatAndroid";
    /** 支付渠道-支付宝 */
    public static final String PAY_CHANNEL_ALI_PAY = "alipay";
    /** 支付渠道-支付宝App */
    public static final String PAY_CHANNEL_ALI_APP_PAY = "alipayApp";

    /** 微信交易类型-JSAPI支付（或小程序支付） */
    public static final String WX_PAY_TRADE_TYPE_JS = "JSAPI";
    /** 微信交易类型-H5支付 */
    public static final String WX_PAY_TRADE_TYPE_H5 = "MWEB";
    /** 微信交易类型-APP支付 */
    public static final String WX_PAY_TRADE_TYPE_APP = "APP";
    /** 微信交易类型-Native支付 */
    public static final String WX_PAY_TRADE_TYPE_NATIVE = "NATIVE";

}
