package com.ishop.merchant;

import com.ishop.model.po.EbProductAttr;

import java.util.List;

/**
 * 商品属性定义缓存。
 * <pre>
 *     1)每个类型 + 商品ID，组成 Key，商品规格定义集合为值（List）
 *     2)可以向每个集合（对应一个KEY）写入或删除元素
 *     3)集合缓存无法全部清空，只能一个一个删除或覆盖
 * </pre>
 * @author 时克英
 * @date 2023-06-14
 */
public interface ProductAttrCache {

    void putList(String key, List<EbProductAttr> data);

    void putList(String key, List<EbProductAttr> data, long expiredSeconds);

    void putListAppend(String key, EbProductAttr data);

    List<EbProductAttr> getList(String key);

    void removeList(String key, EbProductAttr data);

    /**
     * 直接删除一个集合，对应key中的整个list
     * @param key
     * @date 2023-08-02
     */
    void removeList(String key);
}
