package com.ishop.merchant;

import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;

import java.util.List;

/**
 * 平台商品分类缓存定义。
 * @author 时克英
 * @date 2023-06-07
 */
public interface ProductCategoryCache {

    List<EbProductCategory> getThirdLevelCategoryList(Integer firstId, int limit);

    /**
     * 获取商品分类树。
     * @param isShow 是否显示：1 或 0，目前看：平台时为空（看所有的），商户必须为1
     * @return
     * @date 2023-06-15 添加参数：isShow支持商户获取树。
     */
    List<ProductCategoryVo> getTree(Integer isShow);

    List<ProductCategoryVo> getListTree();

    EbProductCategory get(int id);

    void save(EbProductCategory category);

    void update(EbProductCategory category);

    void remove(int id);
}
