package com.ishop.merchant;

public class ProductConstants {

    public static final int PRODUCT_STATUS_UP = 1;          // 出售中（已上架）
    public static final int PRODUCT_STATUS_DOWN = 2;        // 未上架（仓库中）
    public static final int PRODUCT_STATUS_OVER = 3;        // 已售罄
    public static final int PRODUCT_STATUS_WARN = 4;        // 警戒库存
    public static final int PRODUCT_STATUS_CYCLE = 5;       // 回收站
    public static final int PRODUCT_STATUS_WAIT_AUDIT = 6;  // 未审核
    public static final int PRODUCT_STATUS_AUDIT_FAILED = 7;// 审核失败

    /** 商品审核状态-无需审核 */
    public static final Integer AUDIT_STATUS_EXEMPTION = 0;
    /** 商品审核状态-待审核 */
    public static final Integer AUDIT_STATUS_WAIT = 1;
    /** 商品审核状态-审核成功 */
    public static final Integer AUDIT_STATUS_SUCCESS = 2;
    /** 商品审核状态-审核拒绝 */
    public static final Integer AUDIT_STATUS_FAIL = 3;

    /** 单规格属性 */
    public static final String SINGLE_ATTR_NAME = "规格";
    /** 单规格属性值 */
    public static final String SINGLE_ATTR_VALUE = "默认";

    // 商品类型 活动类型 0=商品，1=秒杀，2=砍价，3=拼团 attrResult表用到
    /** 商品类型——普通商品 */
    public static final Integer PRODUCT_TYPE_NORMAL = 0;
    /** 商品类型——普通商品文字 */
    public static final String PRODUCT_TYPE_NORMAL_STR = "默认";
    public static final String PRODUCT_TYPE_NORMAL_KEY = "normal";
    /** 商品类型——秒杀商品 */
    public static final Integer PRODUCT_TYPE_SECKILL = 1;
    /** 商品类型——秒杀商品文字 */
    public static final String PRODUCT_TYPE_SECKILL_STR = "秒杀";
    public static final String PRODUCT_TYPE_SECKILL_KEY = "seckill";
    /** 商品类型——砍价商品 */
    public static final Integer PRODUCT_TYPE_BARGAIN = 2;
    /** 商品类型——砍价商品文字 */
    public static final String PRODUCT_TYPE_BARGAIN_STR = "砍价";
    /** 商品类型——拼团商品 */
    public static final Integer PRODUCT_TYPE_PINGTUAN= 3;
    /** 商品类型——拼团商品文字 */
    public static final String PRODUCT_TYPE_PINGTUAN_STR= "拼团";
    /** 商品类型——组件商品 */
    public static final Integer PRODUCT_TYPE_COMPONENT= 4;
    /** 商品类型——组件商品文字 */
    public static final String PRODUCT_TYPE_COMPONENT_STR= "组件";
    public static final String PRODUCT_TYPE_VIDEO_KEY = "video";

    /** 商品关系类型-收藏 */
    public static final String PRODUCT_RELATION_TYPE_COLLECT = "collect";

    /** 商品评论类型-所有 */
    public static final String PRODUCT_REPLY_TYPE_ALL = "all";
    /** 商品评论类型-好评 */
    public static final String PRODUCT_REPLY_TYPE_GOOD = "good";
    /** 商品评论类型-中评 */
    public static final String PRODUCT_REPLY_TYPE_MEDIUM = "medium";
    /** 商品评论类型-差评 */
    public static final String PRODUCT_REPLY_TYPE_POOR = "poor";
}
