package com.ishop.merchant.cache;

import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.Constants;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.vo.ArticleCategoryVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalArticleCateCache extends AbstractCacheProvider<ArticleCategoryVo> implements ArticleCategoryCache {

    @Override
    public List<ArticleCategoryVo> getList() {
        List<ArticleCategoryVo> data = new ArrayList<>(2);
        ArticleCategoryVo vo = null;
        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            vo = (ArticleCategoryVo) it.next().getValue();
            if(vo.getStatus()){
                data.add(vo);
            }
        }
        return data;
    }

    @Override
    public ArticleCategoryVo get(long id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(ArticleCategoryVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(ArticleCategoryVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbArticleCategory> hosts = this.articleService.selectAll(new EbArticleCategory());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbArticleCategory h : hosts){
                if(h.getIsDel().intValue() == 1){
                    continue;
                }
                cache.put(String.valueOf(h.getId()), VoUtils.acquireArticleCategoryVo(h, StringUtils.EMPTY_STRING));
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_ARTICLE_CATE;
    }

    @Override
    public Class<?> getProviderType() {
        return ArticleCategoryVo.class;
    }

    public void setArticleService(ArticleServiceImpl articleService) {
        this.articleService = articleService;
    }

    private ArticleServiceImpl articleService;
}
