package com.ishop.merchant.cache;

import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.Constants;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.util.CityUtils;
import com.ishop.model.po.EbCityRegion;
import com.ishop.model.vo.CityTreeVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class LocalCityCache extends AbstractCacheProvider<CityTreeVo> implements CityCacheProvider {

    private List<CityTreeVo> cityTreeVoList = new ArrayList<>(8);

    @Override
    public List<CityTreeVo> getTree() {
        return this.cityTreeVoList;
    }

    @Override
    public List<CityTreeVo> getList() {
        throw new UnsupportedOperationException("暂未实现代码");
    }

    @Override
    public CityTreeVo get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(CityTreeVo category) {
        this.putCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void update(CityTreeVo category) {
        this.updateCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbCityRegion> data = this.cityService.queryAllCityForCacheTree();
        if(!StringUtils.isEmptyList(data)){
//            CityTreeVo cityTreeVo = null;
//            int regionType = 0;
//            Map<Integer, CityTreeVo> tempMap = new HashMap<>(data.size());
//
//            for(EbCityRegion cityRegion : data){
//                // 每条数据线加入到缓存
//                cityTreeVo = CityUtils.transferTo(cityRegion);
//                cache.put(String.valueOf(cityRegion.getRegionId()), cityTreeVo);
//                tempMap.put(cityRegion.getRegionId(), cityTreeVo);
//
//                this.cityTreeVoList.add(cityTreeVo);
//            }
//
//            for(Iterator<CityTreeVo> it = this.cityTreeVoList.iterator(); it.hasNext();){
//                cityTreeVo = it.next();
//                regionType = cityTreeVo.getRegionType().intValue();
//                // 第一级节点：省份
//                if(regionType == CityVo.TYPE_PROVINCE){
//                    continue;
//                }
//
//                // 第二级节点：城市
//                if(regionType == CityVo.TYPE_CITY){
//                    tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
//                    it.remove();
//                    continue;
//                }
//
//                // 第三级节点：区县
//                if(regionType == CityVo.TYPE_DISTRICT){
//                    tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
//                    it.remove();
//                    continue;
//                }
//                // 第四级节点：街道
//                if(regionType == CityVo.TYPE_STREET){
//                    tempMap.get(cityTreeVo.getParentId()).addChild(cityTreeVo);
//                    it.remove();
//                    continue;
//                }
//            }
//            tempMap.clear();
            CityUtils.buildTree(this.cityTreeVoList, data, cache);
            logger.info("城市区域树根节点（数量）：" + this.cityTreeVoList.size());
            return data.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CITY;
    }

    @Override
    public Class<?> getProviderType() {
        return CityTreeVo.class;
    }

    public void setCityService(CityServiceImpl cityService) {
        this.cityService = cityService;
    }

    private CityServiceImpl cityService;
}
