package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ExpressCache;
import com.ishop.merchant.service.ExpressServiceImpl;
import com.ishop.model.po.EbExpress;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

public class LocalExpressCache extends AbstractCacheProvider<EbExpress> implements ExpressCache {

    @Override
    public EbExpress get(String code) {
        if(StringUtils.isEmpty(code)){
            throw new IllegalArgumentException("请输入快递公司代码");
        }
        EbExpress express = this.getCacheData(code);
        if(express == null){
            express = this.expressService.queryOne(code);
            if(express == null){
                throw new IllegalStateException("数据库未加载到快递单位：" + code);
            }
            this.putCacheData(code, express);
        }
        return express;
    }

    @Override
    public void save(EbExpress category) {
        this.putCacheData(category.getCode(), category);
    }

    @Override
    public void update(EbExpress category) {
        this.updateCacheData(category.getCode(), category);
    }

    @Override
    public void remove(String code) {
        this.removeCacheData(code);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        // 为了降低开发消耗，采用懒加载方式，初始化不加载。
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_EXPRESS;
    }

    @Override
    public Class<?> getProviderType() {
        return EbExpress.class;
    }

    public void setExpressService(ExpressServiceImpl expressService) {
        this.expressService = expressService;
    }

    private ExpressServiceImpl expressService;
}
