package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.LevelCache;
import com.ishop.merchant.service.LevelServiceImpl;
import com.ishop.model.po.EbLevel;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalLevelCache extends AbstractCacheProvider<EbLevel> implements LevelCache {

    @Override
    public EbLevel get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbLevel category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbLevel category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbLevel> hosts = this.levelService.selectAll(new EbLevel());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbLevel h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_LEVEL;
    }

    @Override
    public Class<?> getProviderType() {
        return EbLevel.class;
    }

    public void setLevelService(LevelServiceImpl levelService) {
        this.levelService = levelService;
    }

    private LevelServiceImpl levelService;
}
