package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.model.po.EbMerchantCategory;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalMerCategoryCache extends AbstractCacheProvider<EbMerchantCategory> implements MerCategoryCacheProvider {

    @Override
    public List<EbMerchantCategory> getList(){
        List<EbMerchantCategory> list = new ArrayList<>(8);
        EbMerchantCategory category = null;
        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            category = (EbMerchantCategory) it.next().getValue();
            if(category.getIsDel().intValue() == 1){
                continue;
            }
            list.add(category);
        }
        return list;
    }

    @Override
    public EbMerchantCategory get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantCategory category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbMerchantCategory category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbMerchantCategory> hosts = this.merchantCategoryService.selectAll(new EbMerchantCategory());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbMerchantCategory h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MER_CATEGORY;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchantCategory.class;
    }

    public void setMerchantCategoryService(MerchantCategoryServiceImpl merchantCategoryService) {
        this.merchantCategoryService = merchantCategoryService;
    }

    private MerchantCategoryServiceImpl merchantCategoryService;
}
