package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.model.po.EbMerchantType;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalMerTypeCache extends AbstractCacheProvider<EbMerchantType> implements MerTypeCacheProvider {

    @Override
    public List<EbMerchantType> getList(){
        List<EbMerchantType> list = new ArrayList<>(8);
        EbMerchantType category = null;
        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            category = (EbMerchantType) it.next().getValue();
            if(category.getIsDel().intValue() == 1){
                continue;
            }
            list.add(category);
        }
        return list;
    }

    @Override
    public EbMerchantType get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantType type) {
        this.putCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void update(EbMerchantType type) {
        this.updateCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbMerchantType> hosts = this.merchantTypeService.selectAll(new EbMerchantType());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbMerchantType h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MER_TYPE;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchantType.class;
    }

    public void setMerchantTypeService(MerchantTypeServiceImpl merchantTypeService) {
        this.merchantTypeService = merchantTypeService;
    }

    private MerchantTypeServiceImpl merchantTypeService;
}
