package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerchantCache;
import com.ishop.merchant.service.MerchantServiceImpl;
import com.ishop.model.po.EbMerchant;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalMerchantCache extends AbstractCacheProvider<EbMerchant> implements MerchantCache {

    @Override
    public EbMerchant get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchant category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbMerchant category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbMerchant> hosts = this.merchantService.selectAll(new EbMerchant());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbMerchant h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MERCHANT;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchant.class;
    }

    public void setMerchantService(MerchantServiceImpl merchantService) {
        this.merchantService = merchantService;
    }

    private MerchantServiceImpl merchantService;
}
