package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.model.po.EbProductAttr;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalProductAttrCache extends AbstractCacheProvider<EbProductAttr> implements ProductAttrCache {

    @Override
    public void putList(String key, List<EbProductAttr> data) {
        this.putCacheList(key, data);
        this.print();
    }

    @Override
    public void putList(String key, List<EbProductAttr> data, long expiredSeconds) {
        this.putCacheList(key, data, expiredSeconds);
    }

    @Override
    public void putListAppend(String key, EbProductAttr data) {
        this.putCacheListAppend(key, data);
    }

    @Override
    public List<EbProductAttr> getList(String key) {
        if(StringUtils.isEmpty(key)){
            throw new IllegalArgumentException("key必须提供");
        }
        List<EbProductAttr> list = this.getCacheList(key);
        if(list == null){
            logger.debug("没有缓存商品属性，从数据库加载并缓存：" + key);
            String[] typeAndProductId = ProductAttrUtils.splitTypeAndProductId(key);
            list = this.productAttrService.queryProductAttrList(Integer.parseInt(typeAndProductId[0]), Long.parseLong(typeAndProductId[1]));
            if(list == null){
                logger.warn("数据库未加载到商品属性，无法缓存：" + key);
                return null;
            }
            this.putList(key, list);
        }
        return list;
    }

    @Override
    public void removeList(String key, EbProductAttr data) {
        this.removeCacheList(key, data);
    }

    @Override
    public void removeList(String key) {
        this.removeCacheList(key);
    }

    public void print(){

    }

    @Override
    protected int loadDataToCache(Cache cache) {
        // 不需要初始化加载
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT_ATTR;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProductAttr.class;
    }

    public void setProductAttrService(ProductAttrServiceImpl productAttrService) {
        this.productAttrService = productAttrService;
    }

    private ProductAttrServiceImpl productAttrService;

}
