package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.po.EbProductCategory;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 平台商品品牌缓存。
 * @author 时克英
 * @date 2023-06-10
 */
public class LocalProductBrandCache extends AbstractCacheProvider<EbProductBrand> implements ProductBrandCache {

    @Override
    public EbProductBrand get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductBrand category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductBrand category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public List<EbProductBrand> getList() {
        List<EbProductBrand> allTree = new ArrayList<>();
        EbProductBrand tempCategory = null;

        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            tempCategory = (EbProductBrand) it.next().getValue();
            if(tempCategory.getIsDel().intValue() == 1){
                continue;
            }
            allTree.add(tempCategory);
        }
        return allTree;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbProductBrand> hosts = this.productBrandService.queryAllProductBrandList();
        if(!StringUtils.isEmptyList(hosts)){
            for(EbProductBrand h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT_BRAND;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProductBrand.class;
    }

    public void setProductBrandService(ProductBrandServiceImpl productBrandService) {
        this.productBrandService = productBrandService;
    }

    private ProductBrandServiceImpl productBrandService;
}
