package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.model.po.EbProduct;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalProductCache extends AbstractCacheProvider<EbProduct> implements ProductCache {

    @Override
    public EbProduct get(long id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProduct category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProduct category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbProduct> hosts = this.productService.selectAll(new EbProduct());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbProduct h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProduct.class;
    }

    public void setProductService(ProductServiceImpl productService) {
        this.productService = productService;
    }

    private ProductServiceImpl productService;
}
