package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.merchant.util.cache.ProductCategorySortComparator;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalProductCategoryCache extends AbstractCacheProvider<EbProductCategory> implements ProductCategoryCache {

    private final ProductCategorySortComparator sortComparator = new ProductCategorySortComparator();

    /**
     * 返回第三级（平台）商品分类集合。
     * @param firstId 第一级ID
     * @param limit 限制几条
     * @return
     * @date 2023-06-23
     */
    @Override
    public List<EbProductCategory> getThirdLevelCategoryList(Integer firstId, int limit){
        List<EbProductCategory> thirdList = new ArrayList<>();
        EbProductCategory tempCategory = null;
        EbProductCategory twoLevelCategory = null;
        int count = 0;
        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            tempCategory = (EbProductCategory) it.next().getValue();
            if(tempCategory.getIsDel().intValue() == 1){
                continue;
            }
            if(tempCategory.getLevel().intValue() != 3){
                continue;
            }
            twoLevelCategory = this.get(tempCategory.getPid());
            if(twoLevelCategory.getIsDel().intValue() != 1 && twoLevelCategory.getPid().intValue() == firstId.intValue()){
                thirdList.add(tempCategory);
                count++;
            }
            if(count >= limit){
                break;
            }
        }
        return thirdList;
    }

    @Override
    public List<ProductCategoryVo> getTree(Integer isShow) {
        List<EbProductCategory> allTree = new ArrayList<>();
        EbProductCategory tempCategory = null;

        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            tempCategory = (EbProductCategory) it.next().getValue();
            if(tempCategory.getIsDel().intValue() == 1){
                continue;
            }
            if(isShow != null && tempCategory.getIsShow().intValue() != isShow.intValue()){
                // 2023-06-15，商户端分类树，需要匹配该字段为：1
                continue;
            }
            allTree.add(tempCategory);
        }
        return ProductCategoryUtils.acquireListTree(allTree, sortComparator);
    }

    @Override
    public List<ProductCategoryVo> getListTree() {
        return this.getTree(null);
    }

    @Override
    public EbProductCategory get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductCategory category) {
        if(StringUtils.isNotEmpty(category.getIcon())){
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductCategory category) {
        if(StringUtils.isNotEmpty(category.getIcon())){
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbProductCategory> data = this.productCategoryService.selectAll(new EbProductCategory());
        if(!StringUtils.isEmptyList(data)){
            for(EbProductCategory d : data){
                if(d.getIsDel().intValue() == 1){
                    continue;
                }
                if(StringUtils.isNotEmpty(d.getIcon())){
                    d.setIcon(this.cdnUrl + d.getIcon());
                }
                cache.put(String.valueOf(d.getId()), d);
            }
            return data.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT_CATEGORY;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProductCategory.class;
    }

    public void setProductCategoryService(ProductCategoryServiceImpl productCategoryService) {
        this.productCategoryService = productCategoryService;
    }

    public void setCdnUrl(String cdnUrl) {
        this.cdnUrl = cdnUrl;
    }

    // 系统配置的存储文件前缀，根据文件存储类型自动配置。2023-06-25
    private String cdnUrl = StringUtils.EMPTY_STRING;
    private ProductCategoryServiceImpl productCategoryService;
}
