package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.model.po.EbUser;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalUserRegCache extends AbstractCacheProvider<EbUser> implements UserRegCache {

    @Override
    public EbUser get(long id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbUser user) {
        this.putCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void update(EbUser user) {
        this.updateCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbUser> hosts = this.userRegisterService.selectAll(new EbUser());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbUser h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER_REG;
    }

    @Override
    public Class<?> getProviderType() {
        return EbUser.class;
    }

    public void setUserRegisterService(UserRegisterServiceImpl userRegisterService) {
        this.userRegisterService = userRegisterService;
    }

    private UserRegisterServiceImpl userRegisterService;
}
