package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.UserRegConfigCache;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.model.po.EbUserConfig;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalUserRegConfigCache extends AbstractCacheProvider<EbUserConfig> implements UserRegConfigCache {

    @Override
    public EbUserConfig get(long id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbUserConfig user) {
        this.putCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void update(EbUserConfig user) {
        this.updateCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbUserConfig> hosts = this.userRegConfigService.selectAll(new EbUserConfig());
        if(!StringUtils.isEmptyList(hosts)){
            for(EbUserConfig h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER_CONFIG;
    }

    @Override
    public Class<?> getProviderType() {
        return EbUserConfig.class;
    }

    public void setUserRegConfigService(UserRegConfigServiceImpl userRegConfigService) {
        this.userRegConfigService = userRegConfigService;
    }

    private UserRegConfigServiceImpl userRegConfigService;
}
