package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.model.po.EbMerchantCategory;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.ArrayList;
import java.util.List;

public class RedisMerCategoryCache extends RedisCacheProvider<EbMerchantCategory> implements MerCategoryCacheProvider {

    public RedisMerCategoryCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public List<EbMerchantCategory> getList(){
        List<EbMerchantCategory> list = new ArrayList<>(8);
        EbMerchantCategory category = null;
        String temp = null;
        try {
            for(String value : ((RedisCache)this.getCache()).getIterator(null)){
                temp = value;
                category = JsonUtils.jsonStringToObject(value, EbMerchantCategory.class);
                list.add(category);
            }
            return list;

        } catch (Exception ex){
            throw new ApplicationRuntimeException("redis存储'EbMerchantCategory'解析错误：" + temp, ex);
        }
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbMerchantCategory> hosts = this.merchantCategoryService.selectAll(new EbMerchantCategory());
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(EbMerchantCategory h : hosts){
                        cache.put(String.valueOf(h.getId()), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    @Override
    public EbMerchantCategory get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantCategory category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbMerchantCategory category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MER_CATEGORY;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchantCategory.class;
    }

    public void setMerchantCategoryService(MerchantCategoryServiceImpl merchantCategoryService) {
        this.merchantCategoryService = merchantCategoryService;
    }

    private MerchantCategoryServiceImpl merchantCategoryService;
}
