package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerProductCategoryCache;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.merchant.util.cache.MerProductCateSortComparator;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisListCacheProvider;

import java.util.Iterator;
import java.util.List;

public class RedisMerProductCategoryCache extends RedisListCacheProvider<EbMerchantProductCategory> implements MerProductCategoryCache {

    private final MerProductCateSortComparator sortComparator = new MerProductCateSortComparator();

    public RedisMerProductCategoryCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putList(String key, List<EbMerchantProductCategory> data) {
        this.putCacheList(key, data);
    }

    @Override
    public void putList(String key, List<EbMerchantProductCategory> data, long expiredSeconds) {
        this.putCacheList(key, data, expiredSeconds);
    }

    @Override
    public void putListAppend(String key, EbMerchantProductCategory data) {
        this.putCacheListAppend(key, data);
    }

    public List<ProductCategoryVo> getTree(String key){
        if(StringUtils.isEmpty(key)){
            throw new IllegalArgumentException("商户商品分类必须提供");
        }
//        List<EbMerchantProductCategory> allTree = new ArrayList<>();
        List<EbMerchantProductCategory> list = this.getList(key);
        if(!StringUtils.isEmptyList(list)){
            // 2023-06-17
            // 注意：这是本地缓存，需要重新创建新集合，把缓存列表映射进来，目的是排除掉无效数据。
            // 但在 Redis 缓存中将不存在该情况，因为数据隔离所以无需重复拷贝。
            EbMerchantProductCategory e = null;
            for(Iterator<EbMerchantProductCategory> it = list.iterator(); it.hasNext();){
                e = it.next();
                if(e.getIsDel().intValue() == 1){
                    it.remove();
                }
                if(e.getIsShow().intValue() == 0){
                    it.remove();
                }
            }
        }
        return ProductCategoryUtils.acquireListTree(list, sortComparator);
    }

    @Override
    public List<EbMerchantProductCategory> getList(String key) {
        if(StringUtils.isEmpty(key)){
            throw new IllegalArgumentException("key必须提供");
        }
        List<EbMerchantProductCategory> list = this.getCacheList(key);
        if(list == null){
            logger.debug("没有缓存商户商品分类，从数据库加载并缓存：" + key);
            list = this.merchantProductCategoryService.queryMerchantProductCategoryList(Integer.parseInt(key));
            if(list == null){
                logger.warn("数据库未加载到:商户商品分类，无法缓存：" + key);
                return null;
            }
            this.putList(key, list);
        }
        return list;
    }

    @Override
    public void removeList(String key, EbMerchantProductCategory data) {
        this.removeCacheList(key, data);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MER_PRODUCT_CATEGORY;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchantProductCategory.class;
    }

    public void setMerchantProductCategoryService(MerchantProductCategoryServiceImpl merchantProductCategoryService) {
        this.merchantProductCategoryService = merchantProductCategoryService;
    }

    private MerchantProductCategoryServiceImpl merchantProductCategoryService;
}
