package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.model.po.EbMerchantType;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.ArrayList;
import java.util.List;

public class RedisMerTypeCache extends RedisCacheProvider<EbMerchantType> implements MerTypeCacheProvider {

    public RedisMerTypeCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public List<EbMerchantType> getList(){
        List<EbMerchantType> list = new ArrayList<>(8);
        EbMerchantType category = null;
        String temp = null;
        try {
            for(String value : ((RedisCache)this.getCache()).getIterator(null)){
                temp = value;
                category = JsonUtils.jsonStringToObject(value, EbMerchantType.class);
                list.add(category);
            }
            return list;

        } catch (Exception ex){
            throw new ApplicationRuntimeException("redis存储'EbMerchantType'解析错误：" + temp, ex);
        }
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbMerchantType> hosts = this.merchantTypeService.selectAll(new EbMerchantType());
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(EbMerchantType h : hosts){
                        cache.put(String.valueOf(h.getId()), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    @Override
    public EbMerchantType get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantType type) {
        this.putCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void update(EbMerchantType type) {
        this.updateCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_MER_TYPE;
    }

    @Override
    public Class<?> getProviderType() {
        return EbMerchantType.class;
    }

    public void setMerchantTypeService(MerchantTypeServiceImpl merchantTypeService) {
        this.merchantTypeService = merchantTypeService;
    }

    private MerchantTypeServiceImpl merchantTypeService;
}
