package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.model.po.EbProductAttr;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisListCacheProvider;

import java.util.List;

public class RedisProductAttrCache extends RedisListCacheProvider<EbProductAttr> implements ProductAttrCache {

    public RedisProductAttrCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putList(String key, List<EbProductAttr> data) {
        this.putCacheList(key, data);
    }

    @Override
    public void putList(String key, List<EbProductAttr> data, long expiredSeconds) {
        this.putCacheList(key, data, expiredSeconds);
    }

    @Override
    public void putListAppend(String key, EbProductAttr data) {
        this.putCacheListAppend(key, data);
    }

    @Override
    public List<EbProductAttr> getList(String key) {
        if(StringUtils.isEmpty(key)){
            throw new IllegalArgumentException("key必须提供");
        }
        List<EbProductAttr> list = this.getCacheList(key);
        if(list == null){
            logger.debug("没有缓存商品属性，从数据库加载并缓存：" + key);
            String[] typeAndProductId = ProductAttrUtils.splitTypeAndProductId(key);
            list = this.productAttrService.queryProductAttrList(Integer.parseInt(typeAndProductId[0]), Long.parseLong(typeAndProductId[1]));
            if(list == null){
                logger.warn("数据库未加载到商品属性，无法缓存：" + key);
                return null;
            }
//            for(Iterator<EbProductAttr> it = list.iterator(); it.hasNext();){
//                if(it.next().getIsDel().intValue() == 1){
//                    it.remove();
//                }
//            }
            this.putList(key, list);
        }
        return list;
    }

    @Override
    public void removeList(String key, EbProductAttr data) {
        this.removeCacheList(key, data);
    }

    @Override
    public void removeList(String key) {
//        List<EbProductAttr> list = this.getCacheList(key);
//        if(!StringUtils.isEmptyList(list)){
//            for(EbProductAttr attr : list){
//                this.removeCacheList(key, attr);
//            }
//        }
        this.removeCacheList(key);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT_ATTR;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProductAttr.class;
    }

    public void setProductAttrService(ProductAttrServiceImpl productAttrService) {
        this.productAttrService = productAttrService;
    }

    private ProductAttrServiceImpl productAttrService;
}
