package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.model.po.EbProductBrand;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.ArrayList;
import java.util.List;

public class RedisProductBrandCache extends RedisCacheProvider<EbProductBrand> implements ProductBrandCache {

    public RedisProductBrandCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<EbProductBrand> hosts = this.productBrandService.queryAllProductBrandList();
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(EbProductBrand h : hosts){
                        cache.put(String.valueOf(h.getId()), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<EbProductBrand> getList() {
        List<EbProductBrand> allTree = new ArrayList<>();
        EbProductBrand tempCategory = null;

        for(String value : this.getCache().getIterator(null)){
            try{
                tempCategory = JsonUtils.jsonStringToObject(value, EbProductBrand.class);
            } catch (Exception ex){
                throw new ApplicationRuntimeException("redis存储'EbProductBrand'解析错误：" + value, ex);
            }
            if(tempCategory.getIsDel().intValue() == 1){
                continue;
            }
            allTree.add(tempCategory);
        }
//        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
//            tempCategory = (EbProductBrand) it.next().getValue();
//            if(tempCategory.getIsDel().intValue() == 1){
//                continue;
//            }
//            allTree.add(tempCategory);
//        }
        return allTree;
    }

    @Override
    public EbProductBrand get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductBrand category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductBrand category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT_BRAND;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProductBrand.class;
    }

    public void setProductBrandService(ProductBrandServiceImpl productBrandService) {
        this.productBrandService = productBrandService;
    }

    private ProductBrandServiceImpl productBrandService;
}
