package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.model.po.EbProduct;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisProductCache extends RedisCacheProvider<EbProduct> implements ProductCache {

    public RedisProductCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public EbProduct get(long id) {
        EbProduct product = this.getCacheData(String.valueOf(id));
        if(product == null){
            product = this.productService.get(new EbProduct(id));
            this.putCacheData(String.valueOf(id), product);
        }
        return product;
    }

    @Override
    public void save(EbProduct category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProduct category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRODUCT;
    }

    @Override
    public Class<?> getProviderType() {
        return EbProduct.class;
    }

    public void setProductService(ProductServiceImpl productService) {
        this.productService = productService;
    }

    private ProductServiceImpl productService;
}
