package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.model.po.EbUser;
import com.walker.support.redis.cache.RedisCacheProvider;

/**
 * 前端注册用户缓存。
 * @author 时克英
 * @date 2023-06-17
 */
public class RedisUserRegCache extends RedisCacheProvider<EbUser> implements UserRegCache {

    public RedisUserRegCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    /**
     * 由于注册用户可能较多，因此在第一次使用时加载到缓存。
     * @param id
     * @return
     */
    @Override
    public EbUser get(long id) {
        String key = String.valueOf(id);
        EbUser user = this.getCacheData(key);
        if(user != null){
            return user;
        }
        logger.debug("缓存不存在用户，第一次从数据库加载：" + id);
        user = this.userRegisterService.get(new EbUser(id));
        if(user == null){
            logger.error("用户不存在，id = " + id);
            return null;
        }
        this.putCacheData(key, user);
        return user;
    }

    @Override
    public void save(EbUser user) {
        this.putCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void update(EbUser user) {
        this.updateCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER_REG;
    }

    @Override
    public Class<?> getProviderType() {
        return EbUser.class;
    }

    public void setUserRegisterService(UserRegisterServiceImpl userRegisterService) {
        this.userRegisterService = userRegisterService;
    }

    private UserRegisterServiceImpl userRegisterService;
}
