package com.ishop.merchant.cache;

import com.ishop.merchant.Constants;
import com.ishop.merchant.UserRegConfigCache;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.model.po.EbUserConfig;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisUserRegConfigCache extends RedisCacheProvider<EbUserConfig> implements UserRegConfigCache {

    public RedisUserRegConfigCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public EbUserConfig get(long id) {
        String key = String.valueOf(id);
        EbUserConfig user = this.getCacheData(key);
        if(user != null){
            return user;
        }
        logger.debug("缓存不存在用户配置，第一次从数据库加载：" + id);
        user = this.userRegConfigService.get(new EbUserConfig(id));
        if(user == null){
            logger.error("用户配置不存在，id = " + id);
            return null;
        }
        this.putCacheData(key, user);
        return user;
    }

    @Override
    public void save(EbUserConfig user) {
        this.putCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void update(EbUserConfig user) {
        this.updateCacheData(String.valueOf(user.getId()), user);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER_CONFIG;
    }

    @Override
    public Class<?> getProviderType() {
        return EbUserConfig.class;
    }

    public void setUserRegConfigService(UserRegConfigServiceImpl userRegConfigService) {
        this.userRegConfigService = userRegConfigService;
    }

    private UserRegConfigServiceImpl userRegConfigService;
}
