package com.ishop.merchant.config;

import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.config.CacheConfiguration;
import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.ExpressCache;
import com.ishop.merchant.LevelCache;
import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.MerProductCategoryCache;
import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.MerchantCache;
import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.UserRegConfigCache;
import com.ishop.merchant.cache.LocalArticleCateCache;
import com.ishop.merchant.cache.LocalCityCache;
import com.ishop.merchant.cache.LocalExpressCache;
import com.ishop.merchant.cache.LocalLevelCache;
import com.ishop.merchant.cache.LocalMerCategoryCache;
import com.ishop.merchant.cache.LocalMerProductCategoryCache;
import com.ishop.merchant.cache.LocalMerTypeCache;
import com.ishop.merchant.cache.LocalMerchantCache;
import com.ishop.merchant.cache.LocalProductAttrCache;
import com.ishop.merchant.cache.LocalProductBrandCache;
import com.ishop.merchant.cache.LocalProductCache;
import com.ishop.merchant.cache.LocalProductCategoryCache;
import com.ishop.merchant.cache.LocalUserRegCache;
import com.ishop.merchant.cache.LocalUserRegConfigCache;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.service.ExpressServiceImpl;
import com.ishop.merchant.service.LevelServiceImpl;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.service.MerchantServiceImpl;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix = "iplatform.cache", name = "redis-enabled", havingValue = "false", matchIfMissing = true)
public class LocalMerchantCacheConfig extends CacheConfiguration {

    /**
     * 快递公司缓存
     * @param expressService
     * @return
     * @date 2023-08-20
     */
    @Bean
    public ExpressCache expressCache(ExpressServiceImpl expressService){
        LocalExpressCache cache = new LocalExpressCache();
        cache.setExpressService(expressService);
        return cache;
    }

    /**
     * 用户自定义配置缓存
     * @param userRegConfigService
     * @return
     * @date 2023-08-06
     */
    @Bean
    public UserRegConfigCache userRegConfigCache(UserRegConfigServiceImpl userRegConfigService){
        LocalUserRegConfigCache cache = new LocalUserRegConfigCache();
        cache.setUserRegConfigService(userRegConfigService);
        return cache;
    }

    /**
     * 商品基本信息缓存
     * @param productService
     * @return
     * @date 2023-07-30
     */
    @Bean
    public ProductCache productCache(ProductServiceImpl productService){
        LocalProductCache cache = new LocalProductCache();
        cache.setProductService(productService);
        return cache;
    }

    @Bean
    public ArticleCategoryCache articleCategoryCache(ArticleServiceImpl articleService){
        LocalArticleCateCache cache = new LocalArticleCateCache();
        cache.setArticleService(articleService);
        return cache;
    }

    /**
     * 系统用户等级定义缓存。
     * @param levelService
     * @return
     * @date 2023-06-30
     */
    @Bean
    public LevelCache levelCache(LevelServiceImpl levelService){
        LocalLevelCache cache = new LocalLevelCache();
        cache.setLevelService(levelService);
        return cache;
    }

    @Bean
    public CityCacheProvider cityCacheProvider(CityServiceImpl cityService){
        LocalCityCache cache = new LocalCityCache();
        cache.setCityService(cityService);
        return cache;
    }

    @Bean
    public UserRegCache userRegCache(UserRegisterServiceImpl userRegisterService){
        LocalUserRegCache cache = new LocalUserRegCache();
        cache.setUserRegisterService(userRegisterService);
        return cache;
    }

    /**
     * 商户商品分类缓存。
     * @param merchantProductCategoryService
     * @return
     * @date 2023-06-16
     */
    @Bean
    public MerProductCategoryCache merProductCategoryCache(MerchantProductCategoryServiceImpl merchantProductCategoryService){
        LocalMerProductCategoryCache cache = new LocalMerProductCategoryCache();
        cache.setMerchantProductCategoryService(merchantProductCategoryService);
        return cache;
    }

    /**
     * 商品属性定义缓存，注意：这是个集合缓存，与之前Hash缓存不同。
     * @param productAttrService
     * @return
     * @date 2023-06-14
     */
    @Bean
    public ProductAttrCache productAttrCache(ProductAttrServiceImpl productAttrService){
        LocalProductAttrCache cache = new LocalProductAttrCache();
        cache.setProductAttrService(productAttrService);
        return cache;
    }

    @Bean
    public MerchantCache merchantCache(MerchantServiceImpl merchantService){
        LocalMerchantCache cache = new LocalMerchantCache();
        cache.setMerchantService(merchantService);
        return cache;
    }

    @Bean
    public ProductBrandCache productBrandCache(ProductBrandServiceImpl productBrandService){
        LocalProductBrandCache cache = new LocalProductBrandCache();
        cache.setProductBrandService(productBrandService);
        return cache;
    }

    @Bean
    public ProductCategoryCache productCategoryCache(ProductCategoryServiceImpl productCategoryService
            , FileOperateSpi fileOperateSpi){
        LocalProductCategoryCache cache = new LocalProductCategoryCache();
        cache.setProductCategoryService(productCategoryService);
        cache.setCdnUrl(fileOperateSpi.getCdnUrl());
        return cache;
    }

    /**
     * 商户分类缓存定义。
     * @param merchantCategoryService
     * @return
     * @date 2023-06-06
     */
    @Bean
    public MerCategoryCacheProvider merCategoryCacheProvider(MerchantCategoryServiceImpl merchantCategoryService){
        LocalMerCategoryCache cache = new LocalMerCategoryCache();
        cache.setMerchantCategoryService(merchantCategoryService);
        return cache;
    }

    @Bean
    public MerTypeCacheProvider merTypeCacheProvider(MerchantTypeServiceImpl merchantTypeService){
        LocalMerTypeCache cache = new LocalMerTypeCache();
        cache.setMerchantTypeService(merchantTypeService);
        return cache;
    }
}
